/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.otheroutbill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.mobim.plugin.form.handler.ImBillChangedHandler;
import kd.scmc.mobim.plugin.form.handler.QuantityBiggerThanZeroHandler;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.otheroutbill.IOtherOutBillPagePlugin;
import kd.scmc.mobim.plugin.form.tpl.MobImBillBeforeF7Select;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryViewPlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.handler.ImBillEntryExpirationDateChangeHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class OtherOutBillEntryEditPlugin
extends MobImBillEntryViewPlugin
implements BeforeF7SelectListener,
IOtherOutBillPagePlugin,
IMobBillEditable {
    private static final long INVCOUNT_BIZTYPE = 688865858117916672L;
    private static final String BILLENTRY = "billentry";
    private static final String BILLENTRY_LK = "billentry_lk";
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "qty", "unit", "warehouse", "location", "biztype", "producedate", "expirydate", "lotnumber", "invscheme"};
    private static final String[] F7_FIELD_KEYS = new String[]{"warehouse", "location", "material"};

    public OtherOutBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new QuantityBiggerThanZeroHandler());
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
        this.registerPropertyChangedHandler(new ImBillChangedHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setEnableByInventory();
        this.setModelNumVisible();
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        MobImBillBeforeF7Select selector = new MobImBillBeforeF7Select(this.getView());
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        String pcEntityKey = this.getPcEntityKey();
        IPageCache pageCache = this.getView().getPageCache();
        int rowIndex = Integer.parseInt(pageCache.get("row"));
        selector.beforeF7Select(evt, pcEntityKey, rowIndex, bill);
    }

    public void setEnableByInventory() {
        long bizTypeId;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        boolean isDraw = this.isDrawByBotp();
        if (isDraw && bizType != null && 688865858117916672L == (bizTypeId = ((Long)bizType.getPkValue()).longValue())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"qty"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"warehouse"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"location"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"location"});
        }
        if (isDraw) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"material"});
        }
    }

    private boolean isDrawByBotp() {
        DynamicObject bill = this.getBill();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryName());
        if (entrys != null && !entrys.isEmpty()) {
            DynamicObjectCollection linkColl = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection(this.getEntryLinkName());
            return linkColl != null && !linkColl.isEmpty();
        }
        return false;
    }

    private String getEntryName() {
        return BILLENTRY;
    }

    private String getEntryLinkName() {
        return BILLENTRY_LK;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("godownuo".equals(key) || "goupop".equals(key)) {
            this.setModelNumVisible();
        }
    }

    private void setModelNumVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material");
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)material.getString("masterid.modelnum"));
        view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.registerPropertyChangedHandler(new ImBillEntryExpirationDateChangeHandler(this.getView(), this.getPcEntityKey()));
        super.propertyChanged(e);
    }
}

