/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.otheroutbill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scmc.mobim.plugin.form.handler.QuantityBiggerThanZeroHandler;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.otheroutbill.IOtherOutBillPagePlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryViewPlugin;

public class OtherOutBillEntryViewPlugin
extends MobImBillEntryViewPlugin
implements IOtherOutBillPagePlugin {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "qty", "unit", "warehouse", "location", "lotnumber", "producedate", "expirydate", "invscheme"};

    public OtherOutBillEntryViewPlugin() {
        this.registerPropertyChangedHandler(new QuantityBiggerThanZeroHandler());
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setModelNumVisible();
    }

    protected void goPreviousOrGoNext(String key) {
        super.goPreviousOrGoNext(key);
        this.setModelNumVisible();
    }

    private void setModelNumVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material");
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)material.getString("masterid.modelnum"));
        view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
    }
}

