/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.producepickbill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.mobim.business.helper.SerialNumberHelper;
import kd.scmc.mobim.common.enums.BillStatusEnum;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.handler.producepick.ProducePickBillChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillInfoPlugin;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class ProducePickEditPlugin
extends MobImBillInfoPlugin
implements IMobBillEditable {
    private static final Log LOG = LogFactory.getLog(ProducePickEditPlugin.class);
    private static final String MOBIM_SERIAL_NUMBER_EDIT = "mobim_serialnumberedit";
    private static final String SCAN_SKIP = "scanSkip";
    private static final String SCAN_SERIAL_NUMBER_BUTTON = "scanserial";
    private static final String MOBIM_PRODUCE_PICK_OUT_ENTRY_EDIT = "mobim_propicoutenedit";
    private static final String MOBIM_PRODUCE_PICK_OUT_VIEW = "mobim_producepickoutview";
    private static final String CUR_ENTRY_INDEX = "curEntryIndex";
    private static final String USE_NEW_PAGE = "useNewPage";

    public ProducePickEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new ProducePickBillChangedHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
    }

    public String getEntryFormKey() {
        return MOBIM_PRODUCE_PICK_OUT_ENTRY_EDIT;
    }

    public String getViewFormId() {
        return MOBIM_PRODUCE_PICK_OUT_VIEW;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SCAN_SERIAL_NUMBER_BUTTON});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject bill = this.curData[0];
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            SerialNumberHelper.countSNNumber(this.getView(), bill, entries, cardEntry, i);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            this.getModel().beginInit();
            SerialNumberHelper.countSNNumber(this.getView(), bill, entries, cardEntry, i);
            this.getModel().endInit();
            this.getView().updateView("serialnumber", i);
        }
    }

    private void handleVisible() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        DynamicObject dyn = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = dyn.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            boolean enableSerial = SerialNumberHelper.isEnableSerial(material);
            cardEntry.setChildVisible(enableSerial, i, new String[]{SCAN_SERIAL_NUMBER_BUTTON});
            cardEntry.setChildVisible(enableSerial, i, new String[]{"serialnumber"});
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control c = (Control)e.getSource();
        String key = c.getKey();
        if (SCAN_SERIAL_NUMBER_BUTTON.equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex(this.getEntryEntity());
            DynamicObject entry = this.getEntry(index);
            DynamicObject material = entry.getDynamicObject("material");
            IFormView view = this.getView();
            if (material == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialIsNull", (String)"scmc-mobim-form", (Object[])new Object[0]));
                return;
            }
            if (!SerialNumberHelper.isEnableSerial(material)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"UnEnableSerialCanNotHandleSerialNumber", (String)"scmc-mobim-form", (Object[])new Object[0]));
                return;
            }
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            if (baseUnit == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"UnitIsNull", (String)"scmc-mobim-form", (Object[])new Object[0]));
                return;
            }
            if (!BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"OnlySaveStatusCanAddSerialNumber", (String)"scmc-mobim-form", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("material", material.getPkValue());
            param.put("unit", baseUnit.getPkValue());
            param.put(CUR_ENTRY_INDEX, index);
            param.put(USE_NEW_PAGE, Boolean.TRUE);
            this.getPageCache().put("customParams", SerializationUtils.toJsonString(param));
            this.scanQrCode();
        }
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }

    protected void scanQrCode() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("method", "scanQRCode");
        HashMap<String, Integer> args = new HashMap<String, Integer>(8);
        args.put("needResult", 1);
        map.put("args", args);
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            try {
                Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                Object qrCode = result.get("qrcode_str");
                this.handleQrCode(qrCode);
            }
            catch (Exception var) {
                LOG.error("\u626b\u63cf\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", (Object)var.getMessage());
                String errMsg = ResManager.loadKDString((String)"\u626b\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"ScanError", (String)"scmc-mobim-form", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
        }
    }

    public void handleQrCode(Object scanCode) {
        String customParams = this.getPageCache().get("customParams");
        if (customParams != null) {
            Boolean useNewPage;
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)customParams, Map.class);
            Boolean bl = useNewPage = paramMap.containsKey(USE_NEW_PAGE) ? (Boolean)paramMap.get(USE_NEW_PAGE) : Boolean.FALSE;
            if (useNewPage.booleanValue()) {
                this.getPageCache().remove("customParams");
                paramMap.put("qrcode_str", scanCode);
                Integer entryIndex = (Integer)paramMap.get(CUR_ENTRY_INDEX);
                DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
                Object pkValue = bill.getPkValue();
                String billType = bill.getDataEntityType().getName();
                DynamicObject org = ProducePickEditPlugin.getBillMainOrg(bill, billType);
                DynamicObject entry = (DynamicObject)bill.getDynamicObjectCollection("billentry").get(entryIndex.intValue());
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                Object entryid = entry.getPkValue();
                String entryName = "billentry";
                paramMap.put("qty", baseQty.intValue());
                paramMap.put("billid", pkValue);
                paramMap.put("billtype", billType);
                paramMap.put("entryid", entryid);
                paramMap.put("entrykey", entryName);
                paramMap.put("invorg", org != null ? org.getPkValue() : null);
                MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
                billShowParameter.setFormId(MOBIM_SERIAL_NUMBER_EDIT);
                billShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                billShowParameter.setCustomParams(paramMap);
                billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCAN_SKIP));
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("viewCallBack".equals(actionId) || "callback".equals(actionId) || SCAN_SKIP.equals(actionId)) {
            DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            for (int i = 0; i < entries.size(); ++i) {
                SerialNumberHelper.countSNNumber(this.getView(), bill, entries, cardEntry, i);
            }
            this.handleVisible();
        }
    }

    private DynamicObject getEntry(int index) {
        DynamicObject billEntity = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        DynamicObjectCollection entryColl = billEntity.getDynamicObjectCollection("billentry");
        return (DynamicObject)entryColl.get(index);
    }
}

