/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.producepickbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.handler.producepick.ProducePickBillChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.tpl.MobImBillBeforeF7Select;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryEditPlugin;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import org.apache.commons.lang3.StringUtils;

public class ProducePickEntryEditPlugin
extends MobImBillEntryEditPlugin {
    private static final String SNFLEX = "snflex";
    private static final String VECTOR_AP = "vectorap";
    private static final String GODOWNOP = "godownuo";
    private static final String GOUPOP = "goupop";

    public ProducePickEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new ProducePickBillChangedHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SNFLEX, VECTOR_AP});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    private void handleVisible() {
        Object material = this.getModel().getValue("material");
        boolean isEnableSerial = material != null && ProducePickEntryEditPlugin.isEnableSerial((DynamicObject)material);
        this.getView().setVisible(Boolean.valueOf(isEnableSerial), new String[]{SNFLEX});
    }

    @Override
    public List<String> getFieldKeys() {
        List<String> fieldKeys = super.getFieldKeys();
        ArrayList<String> keys = new ArrayList<String>(8);
        keys.addAll(fieldKeys);
        keys.add("manubill");
        keys.add("cansendqty");
        keys.add("baseunit");
        return keys;
    }

    @Override
    public void click(EventObject e) {
        String key;
        this.getModel().beginInit();
        super.click(e);
        Control c = (Control)e.getSource();
        switch (key = c.getKey()) {
            case "snflex": 
            case "vectorap": {
                this.goSnEdit();
                break;
            }
            case "godownuo": 
            case "goupop": {
                this.handleVisible();
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("warehouse".equals(fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                e.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)((Long)org.getPkValue()));
            QFilter qfilter = new QFilter("id", "in", (Object)warehouseids);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)((Long)org.getPkValue()));
            showParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
            showParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else {
            MobImBillBeforeF7Select selector = new MobImBillBeforeF7Select(this.getView());
            DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
            String pcEntityKey = this.getPcEntityKey();
            IPageCache pageCache = this.getView().getPageCache();
            int rowIndex = Integer.parseInt(pageCache.get("row"));
            selector.beforeF7Select(e, pcEntityKey, rowIndex, bill);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        int row = Integer.parseInt(this.getPageCache().get("row"));
        DataChangedHandlerHelper.onEntryPagePropertyChanged((AbstractMobFormPlugin)this, (IPropertyChangedHandler)this.propertyChangedHandler, (PropertyChangedArgs)e, (int)row);
    }

    private void goSnEdit() {
        DynamicObject bill = this.getBill();
        Object pkValue = bill.getPkValue();
        String billtype = bill.getDataEntityType().getName();
        String entryName = "billentry";
        DynamicObject org = ProducePickEntryEditPlugin.getBillMainOrg(bill, billtype);
        String row = this.getPageCache().get("row");
        int index = Integer.parseInt(row);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
        DynamicObject entry = (DynamicObject)entrys.get(index);
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        IFormView view = this.getView();
        if (material == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialIsNull", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        if (!ProducePickEntryEditPlugin.isEnableSerial(material)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"UnEnableSerialCanNotHandleSerialNumber", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        if (baseUnit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"UnitIsNull", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        Object entryid = entry.getPkValue();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("material", material.getPkValue());
        param.put("unit", baseUnit.getPkValue());
        param.put("qty", baseQty.intValue());
        param.put("billid", pkValue);
        param.put("billtype", billtype);
        param.put("entryid", entryid);
        param.put("entrykey", entryName);
        param.put("invorg", org != null ? org.getPkValue() : null);
        MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "snclose"));
        billShowParameter.setFormId("mobim_serialnumberedit");
        billShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        billShowParameter.setCustomParams(param);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"snclose")) {
            this.getView().updateView();
        }
    }

    private static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }
}

