/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.producepickbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryViewPlugin;

public class ProducePickEntryViewPlugin
extends MobImBillEntryViewPlugin {
    private static final String SNFLEX = "snflex";
    private static final String VECTOR_AP = "vectorap";
    private static final String GODOWNOP = "godownuo";
    private static final String GOUPOP = "goupop";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SNFLEX, VECTOR_AP});
    }

    @Override
    public List<String> getFieldKeys() {
        List<String> fieldKeys = super.getFieldKeys();
        ArrayList<String> keys = new ArrayList<String>(8);
        keys.addAll(fieldKeys);
        keys.add("manubill");
        keys.add("cansendqty");
        keys.add("baseunit");
        return keys;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    private void handleVisible() {
        Object material = this.getModel().getValue("material");
        boolean isEnableSerial = material != null && ProducePickEntryViewPlugin.isEnableSerial((DynamicObject)material);
        this.getView().setVisible(Boolean.valueOf(isEnableSerial), new String[]{SNFLEX});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "snflex": 
            case "vectorap": {
                this.goSnView();
                break;
            }
            case "godownuo": 
            case "goupop": {
                this.handleVisible();
                break;
            }
        }
    }

    private void goSnView() {
        DynamicObject bill = this.getBill();
        Object pkValue = bill.getPkValue();
        String billtype = bill.getDataEntityType().getName();
        String entryName = "billentry";
        DynamicObject org = ProducePickEntryViewPlugin.getBillMainOrg(bill, billtype);
        String row = this.getPageCache().get("row");
        int index = Integer.parseInt(row);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)entrys.get(index);
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        IFormView view = this.getView();
        Object entryid = entry.getPkValue();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("material", material.getPkValue());
        param.put("unit", baseUnit.getPkValue());
        param.put("qty", baseQty.intValue());
        param.put("billid", pkValue);
        param.put("billtype", billtype);
        param.put("entryid", entryid);
        param.put("entrykey", entryName);
        param.put("invorg", org != null ? org.getPkValue() : null);
        HashMap<String, Object> skipParams = new HashMap<String, Object>(8);
        skipParams.put("entityNumber", "mobim_mftmanuinentryview");
        String billNo = bill.getString("billno");
        skipParams.put("billNo", billNo);
        skipParams.put("billId", pkValue);
        skipParams.put("orgId", org != null ? org.getPkValue() : null);
        String jsonString = SerializationUtils.toJsonString(skipParams);
        param.put("skipParams", jsonString);
        MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
        billShowParameter.setFormId("mobim_serialnumberview");
        billShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        billShowParameter.setCustomParams(param);
        view.showForm((FormShowParameter)billShowParameter);
    }

    private static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }
}

