/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.producepickbill;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.scmc.mobim.business.helper.SerialNumberHelper;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillInfoPlugin;
import kd.scmc.msmob.common.enums.BillStatusEnum;

public class ProducePickViewPlugin
extends MobImBillInfoPlugin {
    public String getEntryFormKey() {
        return "mobim_propicoutenview";
    }

    public String getEditFormId() {
        return "mobim_producepickoutedit";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject bill = this.curData[0];
        DynamicObjectCollection enters = bill.getDynamicObjectCollection("billentry");
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int i = 0; i < enters.size(); ++i) {
            SerialNumberHelper.countSNNumber(this.getView(), bill, enters, cardEntry, i);
        }
        String permission = (String)this.getView().getFormShowParameter().getCustomParam("permission");
        String billstatus = (String)this.getView().getFormShowParameter().getCustomParam("billstatus");
        if ("isView".equals(permission) || kd.scmc.mobim.common.enums.BillStatusEnum.SAVE.getValue().equals(billstatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
        }
    }

    public void setBillStatus() {
        super.setBillStatus();
        String billStatus = (String)this.getModel().getValue("billStatus");
        if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonunaudit"});
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("viewCallBack".equals(actionId) || "callback".equals(actionId)) {
            this.handleVisible();
        }
    }

    private void handleVisible() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        DynamicObject dyn = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = dyn.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            boolean enableSerial = SerialNumberHelper.isEnableSerial(material);
            cardEntry.setChildVisible(enableSerial, i, new String[]{"serialnumber"});
        }
    }
}

