/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.productinbill;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.scmc.mobim.business.helper.InverseBillHelper;
import kd.scmc.mobim.common.utils.BotpUtils;
import kd.scmc.mobim.common.utils.MetaUtils;
import kd.scmc.mobim.plugin.form.handler.QuantityBiggerThanZeroHandler;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.handler.productinbill.ProductInBillChangedHandler;
import kd.scmc.mobim.plugin.form.handler.productinbill.ProductInBillNewEntryHandler;
import kd.scmc.mobim.plugin.form.productinbill.IProductInBillPagePlugin;
import kd.scmc.mobim.plugin.form.tpl.MobImBillHandelQrCode;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;

public class ProductInBillEditPlugin
extends MobPushTargetBillInfoPlugin
implements IProductInBillPagePlugin,
IMobBillEditable,
PagerClickListener {
    public ProductInBillEditPlugin() {
        this.registerPropertyChangedHandler(new QuantityBiggerThanZeroHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
        this.registerPropertyChangedHandler(new ProductInBillChangedHandler());
        this.registerEntryRowAddedHandler(new ProductInBillNewEntryHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryEntity());
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addPagerClickListener((PagerClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.curData != null && this.curData.length > 0 && MetaUtils.isExistFieldKey(this.curData[0], "invscheme")) {
            boolean isNegativeBill = InverseBillHelper.isRedBill(this.curData[0]);
            this.getPageCache().put("isNegativeBill", String.valueOf(isNegativeBill));
            boolean isDraw = this.isDrawByBotp();
            if (isDraw) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"newentryop"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"scanbtn"});
            }
        }
    }

    protected boolean isDrawByBotp() {
        IFormView view = this.getView();
        String pcEntityKey = this.getPcEntityKey();
        return BotpUtils.isDrawByBotp(view, pcEntityKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setColumnColor();
    }

    protected void handleQrCode(Object code) {
        super.handleQrCode(code);
        String pcEntityKey = this.getPcEntityKey();
        String entryKey = this.getEntryEntity();
        IEntryRowAddedHandler entryRowAddedHandler = this.getEntryRowAddedHandler();
        MobImBillHandelQrCode.handleQrCode(code, pcEntityKey, entryKey, this, entryRowAddedHandler);
    }

    private void setColumnColor() {
        DynamicObject bill;
        DynamicObject dynamicObject = bill = this.curData == null || this.curData.length == 0 ? null : this.curData[0];
        if (bill == null) {
            bill = this.getBill();
        }
        if (bill == null) {
            return;
        }
        Set<String> headColumns = Collections.singleton("billno");
        HashSet<String> negativeNumColumns = new HashSet<String>(16);
        HashSet<String> entryColumns = new HashSet<String>(16);
        entryColumns.add("qty");
        negativeNumColumns.add("qty");
        String pcEntityKey = this.getPcEntityKey();
        InverseBillHelper.handleInverseColumnByPcEntity(this.getView(), pcEntityKey, bill, headColumns, entryColumns, negativeNumColumns);
    }

    public String getEntryFormKey() {
        return this.getEntryEditFormKey(this.getEntryEntity());
    }

    public String getViewFormId() {
        return "mobim_productbillinview";
    }

    public void pagerClick(PagerClickEvent e) {
        IPageCache pageCache = this.getPageCache();
        int pageSize = e.getPageRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        int totalRows = entity.size();
        int currPageNum = e.getCurrentPageIndex();
        int startRowIndex = pageSize * (currPageNum - 1);
        int endRowSeq = startRowIndex + pageSize > totalRows ? totalRows : startRowIndex + pageSize;
        int endRowIndex = endRowSeq - 1;
        HashSet<String> negativeNumColumns = new HashSet<String>(16);
        HashSet<String> entryColumns = new HashSet<String>(16);
        entryColumns.add("qty");
        negativeNumColumns.add("qty");
        String isNegative = pageCache.get("isNegativeBill");
        boolean isNegativeBill = StringUtils.isNotEmpty((CharSequence)isNegative) && isNegative.equals("true");
        String pcEntityKey = this.getPcEntityKey();
        InverseBillHelper.handleEntryInverseColumn(this.getView(), pcEntityKey, entryColumns, negativeNumColumns, isNegativeBill, startRowIndex, endRowIndex);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("viewCallBack".equals(e.getActionId()) || "callback".equals(e.getActionId())) {
            this.setColumnColor();
        }
    }
}

