/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.productinbill;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.scmc.mobim.business.helper.InverseBillHelper;
import kd.scmc.mobim.business.helper.VisibleAbilityHelper;
import kd.scmc.mobim.common.utils.BotpUtils;
import kd.scmc.mobim.common.utils.DateUtils;
import kd.scmc.mobim.plugin.form.handler.QuantityBiggerThanZeroHandler;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.handler.WarehouseChangeResetLocationHandler;
import kd.scmc.mobim.plugin.form.handler.productinbill.ProductInBillChangedHandler;
import kd.scmc.mobim.plugin.form.productinbill.IProductInBillPagePlugin;
import kd.scmc.mobim.plugin.form.tpl.MobImBillBeforeF7Select;
import kd.scmc.mobim.plugin.tpl.imtpl.handler.ImBillEntryExpirationDateChangeHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class ProductInBillEntryEditPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
IProductInBillPagePlugin,
IMobBillEditable {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "unit", "qty", "warehouse", "location", "lotnumber", "billid", "pcentitykey", "producedate", "expirydate", "invscheme", "org"};
    private static final String[] F7_FIELD_KEYS = new String[]{"warehouse", "location", "material"};
    private static final String[] QTY_TYPE_FIELDS = new String[]{"qty"};

    public ProductInBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new QuantityBiggerThanZeroHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
        this.registerPropertyChangedHandler(new ProductInBillChangedHandler());
        this.registerPropertyChangedHandler(new WarehouseChangeResetLocationHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setColumnsColor();
        IFormView pcEntityStorageView = this.getPcEntityStorageView();
        String pcEntityKey = this.getPcEntityKey();
        IFormView view = this.getView();
        BotpUtils.setEnableByBotp(view, pcEntityStorageView, pcEntityKey, "material");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        VisibleAbilityHelper visibleAbilityHelper = new VisibleAbilityHelper(this.getView(), this.getModel());
        visibleAbilityHelper.setVisibleAbility();
    }

    private void setColumnsColor() {
        IFormView view = this.getView();
        boolean isInverseBill = this.isInverseBill();
        InverseBillHelper.setHeadColumsColor(view, QTY_TYPE_FIELDS, isInverseBill);
    }

    private boolean isInverseBill() {
        return InverseBillHelper.judgeIsInverseBillByPcEntity(EntityCacheHelper.getPcEntityFromCache((IMobilePage)this));
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        MobImBillBeforeF7Select selector = new MobImBillBeforeF7Select(this.getView());
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        String pcEntityKey = this.getPcEntityKey();
        IPageCache pageCache = this.getView().getPageCache();
        int rowIndex = Integer.parseInt(pageCache.get("row"));
        selector.beforeF7Select(evt, pcEntityKey, rowIndex, bill);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "materialLifeDate": {
                this.materialDateChangedConfirmCallBack(result, e.getCustomVaule());
                break;
            }
        }
    }

    private void materialDateChangedConfirmCallBack(MessageBoxResult result, String customValue) {
        Map dateChangedConfirmMap = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        Date newExpiryDate = DateUtils.parseShortDate((String)dateChangedConfirmMap.get("newExpiryDate"), false);
        Date newProduceDate = DateUtils.parseShortDate((String)dateChangedConfirmMap.get("newProduceDate"), false);
        int changedRowIndex = (Integer)dateChangedConfirmMap.get("changedRowIndex");
        boolean confirmed = MessageBoxResult.Yes.equals((Object)result);
        DataChangedHandlerHelper.setEntryValueManual((AbstractMobFormPlugin)this, (String)this.getPcEntityKey(), (int)changedRowIndex, (pcEntityFromCache, changedEntry) -> {
            changedEntry.set("expirydate", (Object)(confirmed ? newExpiryDate : null));
            changedEntry.set("producedate", (Object)(confirmed ? newProduceDate : null));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.registerPropertyChangedHandler(new ImBillEntryExpirationDateChangeHandler(this.getView(), this.getPcEntryName()));
        super.propertyChanged(e);
    }
}

