/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.productinbill;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scmc.mobim.business.helper.InverseBillHelper;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryViewPlugin;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;

public class ProductInBillEntryViewPlugin
extends MobImBillEntryViewPlugin {
    private static final String[] QTY_TYPE_FIELDS = new String[]{"qty"};

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setColumnsColor();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleAbility();
    }

    private void setColumnsColor() {
        IFormView view = this.getView();
        boolean isInverseBill = this.isInverseBill();
        InverseBillHelper.setHeadColumsColor(view, QTY_TYPE_FIELDS, isInverseBill);
    }

    private boolean isInverseBill() {
        return InverseBillHelper.judgeIsInverseBillByPcEntity(EntityCacheHelper.getPcEntityFromCache((IMobilePage)this));
    }

    private void setVisibleAbility() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object material = model.getValue("material");
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)material).getString("masterid.modelnum"));
        boolean isEnableLot = material != null && ((DynamicObject)material).getBoolean("enablelot");
        view.setVisible(Boolean.valueOf(isEnableLot), new String[]{"lotnumber"});
        view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }
}

