/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.purreceive;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobim.business.helper.OrgHelper;
import kd.scmc.msmob.common.enums.LogicSymbol;
import kd.scmc.msmob.plugin.tpl.basetpl.MobSrcBillBotpListTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PushParams;

public class PurReceiveAddMobFormPlugin
extends MobSrcBillBotpListTplPlugin {
    public PushParams getPushParams(int selectedRow) {
        PushParams pushParams = new PushParams();
        IDataModel model = this.getModel();
        String orderBillNumber = this.getPcEntityKey();
        String purOrderBillNo = (String)model.getValue("billno", selectedRow);
        QFilter srcFilter = new QFilter("billno", "=", (Object)purOrderBillNo);
        srcFilter.and("billstatus", "=", (Object)"C");
        srcFilter.and("closestatus", "=", (Object)"A");
        srcFilter.and("billentry.rowclosestatus", "=", (Object)"A");
        srcFilter.and("billentry.rowterminatestatus", "=", (Object)"A");
        srcFilter.and("changestatus", "!=", (Object)"B");
        srcFilter.and("billtype.number", "!=", (Object)"pm_PurOrderBill_Cost_BT_S");
        srcFilter.and("billentry.material.masterid.materialtype", "!=", (Object)"7");
        srcFilter.and(QFilter.of((String)"billentry.baseqty > billentry.joinbaseqty", (Object[])new Object[0]));
        pushParams.setSrcEntityKey(orderBillNumber);
        pushParams.setSrcMainEntryKey("billentry");
        pushParams.setSrcEntityFilter(srcFilter);
        pushParams.setTargetEntityKey("im_purreceivebill");
        pushParams.setTargetMobFormKey("mobim_purreceiveedit");
        return pushParams;
    }

    public List<FilterCondition> getFilters() {
        List filters = super.getFilters();
        this.addFilters(filters);
        return filters;
    }

    private void addFilters(List<FilterCondition> filters) {
        DynamicObject org;
        FormShowParameter param = this.getView().getFormShowParameter();
        Object orgBillNo = param.getCustomParam("orgBillNo");
        FilterCondition condition = new FilterCondition("billstatus", "=", (Object)"C");
        if (!ObjectUtils.isEmpty((Object)orgBillNo) && (org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", orgBillNo)})) != null) {
            List<Long> purOrgList = OrgHelper.getPurOrgsFromInvOrg(org.getLong("id"));
            condition.and("org.id", "in", purOrgList);
        }
        condition.and("closestatus", "=", (Object)"A");
        condition.and("changestatus", "!=", (Object)"B");
        condition.and("billentry.rowclosestatus", "=", (Object)"A");
        condition.and("billentry.rowterminatestatus", "=", (Object)"A");
        condition.and("billtype.number", "!=", (Object)"pm_PurOrderBill_Cost_BT_S");
        condition.of("billentry.baseqty > billentry.joinbaseqty", LogicSymbol.AND, new Object[0]);
        condition.and("billentry.material.masterid.materialtype", "!=", (Object)"7");
        filters.add(condition);
    }
}

