/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.saloutbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ImLotHelper;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.mobim.plugin.form.handler.saloutbill.SalOutBillChangedHandler;
import kd.scmc.mobim.plugin.form.handler.saloutbill.SalOutBillNewEntryHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.saloutbill.ISalOutBillPagePlugin;
import kd.scmc.mobim.plugin.form.tpl.MobImBillHandelQrCode;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillInfoPlugin;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import org.apache.commons.lang3.StringUtils;

public class SalOutBillEditPlugin
extends MobImBillInfoPlugin
implements ISalOutBillPagePlugin,
IMobBillEditable {
    private static final String PRODUCEDATE = "producedate";
    private static final String EXPIRYDATE = "expirydate";

    public SalOutBillEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new SalOutBillChangedHandler());
        this.registerEntryRowAddedHandler(new SalOutBillNewEntryHandler());
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject bill = this.getModel().getDataEntity(true);
        boolean fromDatabase = bill.getDataEntityState().getFromDatabase();
        if (!fromDatabase && this.isDrawByBotp()) {
            this.setLifeDateByLotNumber();
        }
    }

    protected void handleQrCode(Object code) {
        super.handleQrCode(code);
        String pcEntityKey = this.getPcEntityKey();
        String entryKey = this.getEntryEntity();
        IEntryRowAddedHandler entryRowAddedHandler = this.getEntryRowAddedHandler();
        MobImBillHandelQrCode.handleQrCode(code, pcEntityKey, entryKey, this, entryRowAddedHandler);
    }

    private void setLifeDateByLotNumber() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("entryentity");
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            HashSet<Object> orgIds = new HashSet<Object>(1);
            HashSet<Object> materialIds = new HashSet<Object>(entryRowCount);
            HashSet<String> lotNumbers = new HashSet<String>(entryRowCount);
            orgIds.add(org.getPkValue());
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject material = (DynamicObject)model.getValue("material", i);
                String lotNumer = (String)model.getValue("lotnumber", i);
                if (StringUtils.isNotEmpty((CharSequence)lotNumer)) {
                    lotNumbers.add(lotNumer);
                }
                if (material == null) continue;
                materialIds.add(material.getPkValue());
            }
            if (!lotNumbers.isEmpty()) {
                Map lotIntrackMap = ImLotHelper.getLotIntrackMap(orgIds, materialIds, lotNumbers);
                for (int i = 0; i < entryRowCount; ++i) {
                    String key;
                    DynamicObject lotinTrack;
                    Date produceDate = (Date)model.getValue(PRODUCEDATE, i);
                    Date expiryDate = (Date)model.getValue(EXPIRYDATE, i);
                    if (produceDate != null || expiryDate != null) continue;
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    String lotNumer = (String)model.getValue("lotnumber", i);
                    if (material == null || !material.getBoolean("enableshelflifemgr") || (lotinTrack = (DynamicObject)lotIntrackMap.get(key = org.getPkValue() + "_" + material.getPkValue() + "_" + lotNumer)) == null) continue;
                    produceDate = lotinTrack.getDate(PRODUCEDATE);
                    expiryDate = lotinTrack.getDate(EXPIRYDATE);
                    this.setValue(PRODUCEDATE, produceDate, i, false);
                    this.setValue(EXPIRYDATE, expiryDate, i, false);
                }
            }
        }
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        if (value instanceof BigDecimal) {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)value), (String)key);
        }
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }
}

