/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.saloutbill;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.MobileFormShowParameter;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.plugin.form.saloutbill.ISalOutBillPagePlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillListPlugin;
import kd.scmc.msmob.pojo.FilterCondition;

public class SalOutBillListPlugin
extends MobImBillListPlugin
implements ISalOutBillPagePlugin {
    public void setModelValue() {
        super.setModelValue();
        this.summaryFields(new String[]{"material"});
    }

    @Override
    public List<FilterCondition> getFilters() {
        List<FilterCondition> filters = super.getFilters();
        this.addAllPermOrgsFilter(filters);
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String orgNumber = (String)param.getCustomParam("orgBillNo");
        if (StringUtils.isNotEmpty((CharSequence)orgNumber)) {
            FilterCondition condition = new FilterCondition("org.number", "=", (Object)orgNumber);
            filters.add(condition);
        }
        return filters;
    }

    private void addAllPermOrgsFilter(List<FilterCondition> qFilters) {
        long userId = RequestContext.get().getCurrUserId();
        List<Long> allPermOrgsFromUser = PermissionHelper.getAllPermOrgsFromUser(userId, this.getPcEntityKey());
        if (allPermOrgsFromUser != null) {
            FilterCondition condition = new FilterCondition("org", "in", allPermOrgsFromUser);
            qFilters.add(condition);
        }
    }
}

