/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.serialnumber;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.mobim.business.helper.StringHelper;
import kd.scmc.msmob.common.utils.PropertyValueUtils;

public class SerialNumberEditPlugin
extends AbstractMobBillPlugIn {
    private static final String MANUALENTRYVECTOR = "manualentryvector";
    private static final String MANUALENTRY = "manualentry";
    private static final String BUTTONEMPTY = "buttonempty";
    private static final String DELETEOPFLEX = "deleteopflex";
    private static final String DELETEENTRYOP = "deleteentryop";
    private static final String DELETE = "delete";
    private static final String EMPTY = "empty";
    public static final String SERIALNUMBER = "serialnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MANUALENTRYVECTOR, MANUALENTRY, DELETEENTRYOP, DELETEOPFLEX, BUTTONEMPTY});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().deleteEntryRow("entryentity", 0);
        this.handleCustomParams(customParams);
        if (customParams != null && customParams.containsKey("qrcode_str")) {
            Object qrcode_str = customParams.get("qrcode_str");
            this.scanAdd((String)qrcode_str);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject dyn = this.getModel().getDataEntity(true);
            DynamicObjectCollection enters = dyn.getDynamicObjectCollection("entryentity");
            if (enters != null && enters.size() > 0) {
                int size = enters.size();
                ArrayList<Integer> index = new ArrayList<Integer>(size);
                for (int i = 0; i < enters.size(); ++i) {
                    String serialnumber = ((DynamicObject)enters.get(i)).getString(SERIALNUMBER);
                    if (!StringUtils.isBlank((CharSequence)serialnumber)) continue;
                    index.add(i);
                }
                if (!index.isEmpty()) {
                    int total = index.size();
                    int[] count = new int[total];
                    for (int i = 0; i < index.size(); ++i) {
                        count[i] = (Integer)index.get(i);
                    }
                    this.getModel().deleteEntryRows("entryentity", count);
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
                    int restSize = collection == null ? 0 : collection.size();
                    for (int i = 0; i < restSize; ++i) {
                        this.setSeq(i);
                    }
                }
            }
            String snBillId = this.getPageCache().get("snBillId");
            option.setVariableValue("snBillId", snBillId);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String jsonString = SerializationUtils.toJsonString((Object)customParams);
            option.setVariableValue("customParams", jsonString);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(key) && (operationResult = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            this.getView().close();
        }
    }

    private void handleCustomParams(Map<String, Object> customParams) {
        if (customParams != null) {
            Object billType = customParams.get("billtype");
            Object entryName = customParams.get("entrykey");
            Object pkValue = customParams.get("billid");
            Object entryId = customParams.get("entryid");
            QFilter filter = new QFilter("billtype", "=", billType).and("entrykey", "=", entryName).and("billid", "=", pkValue).and("entryid", "=", entryId);
            DynamicObject billSNRelation = BusinessDataServiceHelper.loadSingle((String)"sbs_billsnrelation", (String)"id,entryentity,entryentity.snnumber", (QFilter[])filter.toArray());
            this.getPageCache().put("snBillId", billSNRelation == null ? "" : String.valueOf(billSNRelation.getPkValue()));
            if (billSNRelation == null) {
                this.setSNNumberCount();
                return;
            }
            DynamicObjectCollection entryCollection = billSNRelation.getDynamicObjectCollection("entryentity");
            if (entryCollection != null && entryCollection.size() > 0) {
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                if (entryCollection.size() > rowCount) {
                    this.getModel().batchCreateNewEntryRow("entryentity", entryCollection.size() - rowCount);
                }
                for (int i = 0; i < entryCollection.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCollection.get(i);
                    this.getModel().setValue(SERIALNUMBER, entry.get("snnumber"), i);
                    this.setSeq(i);
                }
            }
            this.setSNNumberCount();
        }
    }

    private void setSNNumberCount() {
        DynamicObject dyn = this.getModel().getDataEntity(true);
        DynamicObjectCollection enters = dyn.getDynamicObjectCollection("entryentity");
        int total = 0;
        for (DynamicObject entry : enters) {
            String serialnumber = entry.getString(SERIALNUMBER);
            if (!StringUtils.isNotBlank((CharSequence)serialnumber)) continue;
            ++total;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object qty = customParams.get("qty");
        String str = ResManager.loadKDString((String)"\u5df2\u5f55\u5165%1$s/%2$s\u4e2a\u5e8f\u5217\u53f7", (String)"MobBillSerialNumber_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
        BigDecimal decimal = new BigDecimal(String.valueOf(qty));
        String text = String.format(str, total, qty == null ? Integer.valueOf(0) : decimal.abs());
        Label label = (Label)this.getView().getControl("snnumbercount");
        label.setText(text);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (MANUALENTRYVECTOR.equals(key) || MANUALENTRY.equals(key)) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.setSeq(row);
        }
        if (BUTTONEMPTY.equals(key)) {
            String msg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u6e05\u7a7a\u5168\u90e8\u5e8f\u5217\u53f7\u5417\uff1f", (String)"MobBillSerialNumber_3", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(EMPTY));
        }
        if (DELETEOPFLEX.equals(key) || DELETEENTRYOP.equals(key)) {
            String msg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u5e8f\u5217\u53f7\u5417\uff1f", (String)"MobBillSerialNumber_4", (String)"scmc-mobim-form", (Object[])new Object[0]);
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(DELETE), null, String.valueOf(index));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        String customVaule = e.getCustomVaule();
        switch (callBackId) {
            case "delete": {
                this.deleteSerialNumber(result, customVaule);
                break;
            }
            case "empty": {
                this.emptySerialNumber(result);
                break;
            }
        }
    }

    private void emptySerialNumber(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            if (rowCount > 0) {
                int[] count = new int[rowCount];
                for (int i = 0; i < rowCount; ++i) {
                    count[i] = i;
                }
                this.getModel().deleteEntryRows("entryentity", count);
            }
            this.setSNNumberCount();
        }
    }

    private void deleteSerialNumber(MessageBoxResult result, String customValue) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            int index = Integer.parseInt(customValue);
            this.getModel().deleteEntryRow("entryentity", index);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            int size = collection.size();
            for (int i = index; i < size; ++i) {
                this.setSeq(i);
            }
        }
        this.setSNNumberCount();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            boolean equal;
            if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) continue;
            Object newValue = valueSet[i].getNewValue();
            int rowIndex = valueSet[i].getRowIndex();
            if (!SERIALNUMBER.equals(propName)) continue;
            if (StringUtils.isNotBlank((Object)newValue) && (equal = this.checkSNNumber(newValue, rowIndex))) {
                String str = ResManager.loadKDString((String)"\u8be5\u5e8f\u5217\u53f7\u5df2\u5b58\u5728\u3002", (String)"MobBillSerialNumber_5", (String)"scmc-mobim-form", (Object[])new Object[0]);
                this.getView().showTipNotification(str);
            }
            this.setSNNumberCount();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if (key.equals("callAppMethod") && eventName.equals("scanQRCode")) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            String qrCode = (String)result.get("qrcode_str");
            qrCode = StringHelper.subString(qrCode, 50);
            this.scanAdd(qrCode);
        }
    }

    private void setSeq(int index) {
        int seq = index + 1;
        this.getModel().setValue("seqlabel", (Object)seq, index);
    }

    private void scanAdd(String qrCode) {
        boolean equal = this.checkSNNumber(qrCode);
        if (equal) {
            String str = ResManager.loadKDString((String)"\u8be5\u5e8f\u5217\u53f7\u5df2\u5b58\u5728\u3002", (String)"MobBillSerialNumber_5", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(str);
        } else {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue(SERIALNUMBER, (Object)qrCode, rowIndex);
            this.setSeq(rowIndex);
        }
        this.setSNNumberCount();
    }

    public boolean checkSNNumber(String number) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        if (null != collection && collection.size() > 0) {
            for (DynamicObject entry : collection) {
                Object snNumber = entry.get(SERIALNUMBER);
                if (snNumber == null || !snNumber.equals(number)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkSNNumber(Object number, int index) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        if (null != collection && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                Object snNumber;
                if (i == index || (snNumber = ((DynamicObject)collection.get(i)).get(SERIALNUMBER)) == null || !snNumber.equals(number)) continue;
                return true;
            }
        }
        return false;
    }
}

