/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.serialnumber;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SerialNumberViewPlugin
extends AbstractMobBillPlugIn {
    public static final String EXITBUTTON = "exitbutton";
    public static final String SERIALNUMBER = "serialnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EXITBUTTON});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().deleteEntryRow("entryentity", 0);
        this.handleCustomParams(customParams);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (EXITBUTTON.equals(key)) {
            this.getView().close();
        }
    }

    private void handleCustomParams(Map<String, Object> customParams) {
        if (customParams != null) {
            Object billType = customParams.get("billtype");
            Object entryName = customParams.get("entrykey");
            Object pkValue = customParams.get("billid");
            Object entryId = customParams.get("entryid");
            Object qty = customParams.get("qty");
            QFilter filter = new QFilter("billtype", "=", billType).and("entrykey", "=", entryName).and("billid", "=", pkValue).and("entryid", "=", entryId);
            DynamicObject billSNRelation = BusinessDataServiceHelper.loadSingle((String)"sbs_billsnrelation", (String)"id,entryentity,entryentity.snnumber", (QFilter[])filter.toArray());
            this.getPageCache().put("snBillId", billSNRelation == null ? "" : String.valueOf(billSNRelation.getPkValue()));
            if (billSNRelation == null) {
                this.setSNNumberCount(qty, 0);
                return;
            }
            DynamicObjectCollection entryCollection = billSNRelation.getDynamicObjectCollection("entryentity");
            this.setSNNumberCount(qty, entryCollection == null ? 0 : entryCollection.size());
            if (entryCollection != null && entryCollection.size() > 0) {
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                if (entryCollection.size() > rowCount) {
                    this.getModel().batchCreateNewEntryRow("entryentity", entryCollection.size() - rowCount);
                }
                for (int i = 0; i < entryCollection.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCollection.get(i);
                    this.getModel().setValue(SERIALNUMBER, entry.get("snnumber"), i);
                    this.setSeq(i);
                }
            }
        }
    }

    private void setSeq(int index) {
        int seq = index + 1;
        this.getModel().setValue("seqlabel", (Object)seq, index);
    }

    private void setSNNumberCount(Object qty, int total) {
        String str = ResManager.loadKDString((String)"\u5df2\u5f55\u5165%1$s/%2$s\u4e2a\u5e8f\u5217\u53f7", (String)"MobBillSerialNumber_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
        BigDecimal decimal = new BigDecimal(String.valueOf(qty));
        String text = String.format(str, total, decimal.abs());
        Label label = (Label)this.getView().getControl("snnumbercount");
        label.setText(text);
    }
}

