/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.tpl;

import java.util.ArrayList;
import java.util.List;
import kd.bd.sbd.enums.BizCategoryEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class MobImBillBeforeF7Select {
    private static final String MASTERID_ENABLEVMI = "masterid.enablevmi";
    private IFormView view = null;

    public MobImBillBeforeF7Select(IFormView view) {
        this.view = view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e, String pcEntityKey, int rowIndex, DynamicObject bill) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("material".equals(fieldKey)) {
            DynamicObjectCollection collection = bill.getDynamicObjectCollection("billentry");
            DynamicObject entry = (DynamicObject)collection.get(rowIndex);
            this.beforeMaterial(showParameter, pcEntityKey, bill, entry);
        } else if ("warehouse".equals(fieldKey)) {
            this.beforeWarehouse(e, showParameter, bill);
        } else if ("location".equals(fieldKey)) {
            this.beforeLocation(e, showParameter, bill, rowIndex);
        }
    }

    private void beforeLocation(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bill, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)((DynamicObject)bill.getDynamicObjectCollection("billentry").get(rowIndex)).get("warehouse");
        if (null == warehouse) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            List<Long> ids = this.getLocationIds(warehouse.getPkValue());
            QFilter qFilter1 = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private List<Long> getLocationIds(Object whId) {
        ArrayList<Long> locationIds = new ArrayList<Long>(2);
        QFilter qFilter = new QFilter("id", "=", whId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WarehouseHelper.class.getName(), (String)"bd_warehouse", (String)"entryentity.location location", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long locationId = row.getLong("location");
                locationIds.add(locationId);
            }
        }
        return locationIds;
    }

    private void beforeWarehouse(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bill) {
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        MainEntityType dataEntityType = (MainEntityType)bill.getDataEntityType();
        String pcEntity = dataEntityType.getName();
        Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)pcEntity, (DynamicObject)org, (ListShowParameter)showParameter);
        if (!result.booleanValue()) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
        }
    }

    private void beforeMaterial(ListShowParameter showParameter, String formId, DynamicObject bill, DynamicObject entry) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7c7b\u578b", (String)"MobImBillBeforeF7Select_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (org != null) {
            QFilter qFilter = new QFilter("masterid.status", "=", (Object)"C");
            qFilter.and("masterid.enable", "=", (Object)"1");
            if (!formId.equals("im_initbill")) {
                Object value;
                if (bizType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b", (String)"MobImBillBeforeF7Select_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
                }
                DynamicObject lineType = entry.getDynamicObject("linetype");
                if (lineType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u884c\u7c7b\u578b", (String)"MobImBillBeforeF7Select_3", (String)"scmc-mobim-form", (Object[])new Object[0]));
                }
                QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                    QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                    qFilter.and(serviceAttrFilter);
                }
            }
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            if (bizType != null) {
                String bizNum = bizType.getString("number");
                String bizCategory = BizCategoryEnum.BZ.getValue();
                if (!("111".equals(bizNum) || "1111".equals(bizNum) || "322".equals(bizNum))) {
                    this.getMaterialFilterByMaterialType(showParameter, qFilter, bizCategory);
                }
                if ("6".equals(bizType.get("domain"))) {
                    switch (formId) {
                        case "im_purreceivebill": 
                        case "im_purinbill": 
                        case "im_materialreqoutbill": 
                        case "im_otheroutbill": 
                        case "im_saloutbill": {
                            qFilter.and(MASTERID_ENABLEVMI, "=", (Object)Boolean.TRUE);
                            showParameter.getListFilterParameter().getQFilters().add(qFilter);
                            break;
                        }
                    }
                }
            } else {
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    private void getMaterialFilterByMaterialType(ListShowParameter showParameter, QFilter qFilter, String bizCategory) {
        List materialTypes = BizTypeHelper.getMaterialQFilterByBizCategory((String)bizCategory);
        if (materialTypes != null && materialTypes.size() != 0) {
            qFilter.and("masterid.materialtype", "in", (Object)materialTypes);
        }
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private IFormView getView() {
        return this.view;
    }
}

