/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.transdirbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.mobim.business.helper.VisibleAbilityHelper;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.tpl.MobApplyBillBeforeF7Select;
import kd.scmc.mobim.plugin.form.transdirbill.ITransApplyBillPagePlugin;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class TransApplyEntryEditPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
ITransApplyBillPagePlugin,
IMobBillEditable {
    private static final Log LOG = LogFactory.getLog(TransApplyEntryEditPlugin.class);
    private static final String TRANS_TYPE = "transtype";
    private static final String TRANS_TYPE_INNER_ORG = "B";
    private static final String[] F7_FIELD_KEYS = new String[]{"outorg", "warehouse", "location", "inorg", "inwarehouse", "inlocation"};
    private static final String[] TRIGGERED_FIELD_KEYS = new String[]{"qty", "outorg", "warehouse", "location", "inorg", "inwarehouse", "inlocation"};
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "transtype", "qty", "unit", "outorg", "warehouse", "location", "inorg", "inwarehouse", "inlocation"};

    public TransApplyEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        VisibleAbilityHelper visibleAbilityHelper = new VisibleAbilityHelper(this.getView(), this.getModel());
        visibleAbilityHelper.setVisibleAbility();
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        String transType = (String)model.getValue(TRANS_TYPE);
        switch (fieldKey) {
            case "outorg": {
                DynamicObject inOrg = (DynamicObject)model.getValue("inorg");
                this.beforeInOrOutOrgSelect(e, inOrg, transType);
                break;
            }
            case "inorg": {
                DynamicObject outOrg = (DynamicObject)model.getValue("outorg");
                this.beforeInOrOutOrgSelect(e, outOrg, transType);
                break;
            }
            case "warehouse": {
                DynamicObject outOrg = (DynamicObject)model.getValue("outorg");
                this.commonWareHouseFilter(outOrg, e);
                break;
            }
            case "inwarehouse": {
                this.beforeSelectInWarehouse(e);
                break;
            }
            case "location": {
                this.beforeSelectLocation(e);
                break;
            }
            case "inlocation": {
                this.beforeSelectInLocation(e);
                break;
            }
        }
        if ("im_transapply".equals(this.getPcEntityKey()) && !"applyuser".equals(fieldKey)) {
            DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
            MobApplyBillBeforeF7Select selector = new MobApplyBillBeforeF7Select();
            selector.beforeF7Select(e, this.getPcEntityKey(), bill);
        }
    }

    private void beforeInOrOutOrgSelect(BeforeF7SelectEvent event, DynamicObject inOrOutOrg, String transType) {
        FormShowParameter formShowParameter = event.getFormShowParameter();
        List orgList = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"05", (boolean)false);
        if (inOrOutOrg != null && TRANS_TYPE_INNER_ORG.equals(transType)) {
            orgList.remove(inOrOutOrg.getLong("id"));
        }
        formShowParameter.setCustomParam("range", (Object)orgList);
    }

    private void commonWareHouseFilter(DynamicObject org, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (org == null) {
            e.setCancel(true);
        } else {
            Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)this.getPcEntityKey(), (DynamicObject)org, (ListShowParameter)showParameter);
            if (!result.booleanValue()) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
            }
        }
    }

    private void beforeSelectInWarehouse(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject inOrg = (DynamicObject)model.getValue("inorg");
        this.commonWareHouseFilter(inOrg, e);
    }

    private void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse");
        this.commonLocationFilter(warehouse, e);
    }

    private void beforeSelectInLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject warehouse = (DynamicObject)model.getValue("inwarehouse");
        this.commonLocationFilter(warehouse, e);
    }

    private void commonLocationFilter(DynamicObject warehouse, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (warehouse == null) {
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = this.getLoactionIds(locationCol, "location");
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol, String locationkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject(locationkey);
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private String getConvertResult() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("convertResult");
    }

    public DynamicObject getBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean isSave = (Boolean)customParams.get("isSave");
        String pcEntityKey = this.getPcEntityKey();
        Long billId = this.getBillId();
        String convertResult = this.getConvertResult();
        DynamicObject bill = StringUtils.isNotEmpty((CharSequence)convertResult) && isSave != null && isSave == false ? BotpHelper.getPushBill((String)convertResult, (boolean)true) : BusinessDataServiceHelper.loadSingle((Object)billId, (String)pcEntityKey);
        return bill;
    }
}

