/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.transdirbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.transdirbill.ITransDirBillPagePlugin;
import kd.scmc.mobim.plugin.form.transdirbill.TransDirBillEntryViewPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class TransDirBillEntryEditPlugin
extends TransDirBillEntryViewPlugin
implements BeforeF7SelectListener,
ITransDirBillPagePlugin,
IMobBillEditable {
    public static final String OUTWAREHOUSE = "outwarehouse";
    public static final String OUTLOCATION = "outlocation";
    public static final String OUTORG = "outorg";
    private static final String[] F7_FIELD_KEYS = new String[]{"outwarehouse", "outlocation", "warehouse", "location"};
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "qty", "unit", "outwarehouse", "outlocation", "warehouse", "location", "invscheme"};

    public void TransDirBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
    }

    public TransDirBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "warehouse": {
                this.beforeSelectWareHouse(e, "org");
                break;
            }
            case "location": {
                this.beforeSelectLocation(e, "warehouse");
                break;
            }
            case "outwarehouse": {
                this.beforeSelectWareHouse(e, OUTORG);
                break;
            }
            case "outlocation": {
                this.beforeSelectLocation(e, OUTWAREHOUSE);
                break;
            }
        }
    }

    private void beforeSelectWareHouse(BeforeF7SelectEvent e, String orgKey) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel model = this.getParentView().getModel();
        DynamicObject org = (DynamicObject)model.getValue(orgKey);
        if (org == null) {
            e.setCancel(true);
        } else {
            Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)this.getPcEntityKey(), (DynamicObject)org, (ListShowParameter)showParameter);
            if (Boolean.FALSE.equals(result)) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
            }
        }
    }

    private void beforeSelectLocation(BeforeF7SelectEvent e, String warehouseKey) {
        IDataModel model = this.getModel();
        DynamicObject warehouse = (DynamicObject)model.getValue(warehouseKey);
        if (warehouse == null) {
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Object> ids = new ArrayList();
            if (locationCol != null && !locationCol.isEmpty()) {
                ids = locationCol.stream().map(dynamicObject -> Long.valueOf(dynamicObject.getDynamicObject("location").getPkValue().toString())).collect(Collectors.toList());
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }
}

