/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.transinbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.handler.TransAmountPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.transinbill.ITransInBillPagePlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryEditPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class TransInBillEntryEditPlugin
extends MobImBillEntryEditPlugin
implements BeforeF7SelectListener,
ITransInBillPagePlugin,
IMobBillEditable {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "org", "pcentitykey", "material", "qty", "unit", "warehouse", "location", "invscheme", "lotnumber", "producedate", "expirydate"};
    private static final String[] F7_FIELD_KEYS = new String[]{"location", "warehouse"};

    public TransInBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new TransAmountPropertyChangedHandler());
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setModelNumVisible();
    }

    protected void goPreviousOrGoNext(String key) {
        super.goPreviousOrGoNext(key);
        this.setModelNumVisible();
    }

    private void setModelNumVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material");
        Boolean isNotEmptyModelNum = material != null && !StringUtils.isEmpty((CharSequence)material.getString("masterid.modelnum"));
        view.setVisible(isNotEmptyModelNum, new String[]{"model"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "warehouse": {
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (org == null) {
                    e.setCancel(true);
                    break;
                }
                Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)this.getPcEntityKey(), (DynamicObject)org, (ListShowParameter)showParameter);
                this.commonWareHouseFilter(result, Long.valueOf(org.getPkValue().toString()), showParameter);
                break;
            }
            case "location": {
                DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
                if (warehouse == null) {
                    e.setCancel(true);
                    break;
                }
                this.commonLocationFilter(warehouse, showParameter);
                break;
            }
        }
    }

    private void commonWareHouseFilter(Boolean result, Long orgId, ListShowParameter showParameter) {
        if (!result.booleanValue()) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)orgId);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
        }
    }

    private void commonLocationFilter(DynamicObject warehouse, ListShowParameter showParameter) {
        DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
        List<Long> ids = this.getLoactionIds(locationCol, "location");
        QFilter qFilter = new QFilter("id", "in", ids);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol, String locationkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject(locationkey);
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }
}

