/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.transoutbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.mobim.plugin.form.handler.ImBillChangedHandler;
import kd.scmc.mobim.plugin.form.handler.TransAmountPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.tpl.MobImBillBeforeF7Select;
import kd.scmc.mobim.plugin.form.transoutbill.ITransOutBillPagePlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryEditPlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.handler.ImBillEntryExpirationDateChangeHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class TransOutBillEntryEditPlugin
extends MobImBillEntryEditPlugin
implements BeforeF7SelectListener,
ITransOutBillPagePlugin,
IMobBillEditable {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "qty", "unit", "warehouse", "location", "invscheme", "lotnumber", "producedate", "expirydate"};
    private static final String[] F7_FIELD_KEYS = new String[]{"warehouse", "location", "material"};

    public TransOutBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new TransAmountPropertyChangedHandler());
        this.registerPropertyChangedHandler(new ImBillChangedHandler());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setModelNumVisible();
    }

    protected void goPreviousOrGoNext(String key) {
        super.goPreviousOrGoNext(key);
        this.setModelNumVisible();
    }

    private void setModelNumVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material");
        Boolean isNotEmptyModelNum = material != null && !StringUtils.isEmpty((CharSequence)material.getString("masterid.modelnum"));
        view.setVisible(isNotEmptyModelNum, new String[]{"model"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "warehouse": {
                this.beforeSelectWareHouse(evt);
                break;
            }
            case "location": {
                this.beforeSelectLocation(evt);
                break;
            }
            case "material": {
                MobImBillBeforeF7Select selector = new MobImBillBeforeF7Select(this.getView());
                DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
                String pcEntityKey = this.getPcEntityKey();
                IPageCache pageCache = this.getView().getPageCache();
                int rowIndex = Integer.parseInt(pageCache.get("row"));
                selector.beforeF7Select(evt, pcEntityKey, rowIndex, bill);
                break;
            }
        }
    }

    private void beforeSelectWareHouse(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel model = this.getParentView().getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            e.setCancel(true);
        } else {
            Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)this.getPcEntityKey(), (DynamicObject)org, (ListShowParameter)showParameter);
            if (Boolean.FALSE.equals(result)) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
            }
        }
    }

    private void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (warehouse == null) {
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Object> ids = new ArrayList();
            if (locationCol != null && !locationCol.isEmpty()) {
                ids = locationCol.stream().map(dynamicObject -> Long.valueOf(dynamicObject.getDynamicObject("location").getPkValue().toString())).collect(Collectors.toList());
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        this.registerPropertyChangedHandler(new ImBillEntryExpirationDateChangeHandler(this.getView(), this.getPcEntityKey()));
        super.propertyChanged(e);
    }
}

