/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.op.skill;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.msmob.plugin.op.skill.ISkill;
import kd.scmc.msmob.pojo.QrCodeResult;

public class InvQuerySkill
implements ISkill {
    public void handle(IFormView view, QrCodeResult result) {
        Object appHomeOrgId = view.getFormShowParameter().getCustomParam("orgid");
        Long orgId = Long.valueOf(String.valueOf(appHomeOrgId));
        boolean orgFunction = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"05");
        if (!orgFunction) {
            String errMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u5e93\u5b58\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u5411\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"LocationTransferSkill_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            view.showErrorNotification(errMessage);
            return;
        }
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        boolean isPerm = PermissionHelper.checkPermission(userId, orgId, "im", "im_invaccreport", "47150e89000000ac");
        if (!isPerm) {
            String errMessage = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u67e5\u8be2\u62a5\u8868\u6743\u9650\uff0c\u8bf7\u5411\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"InvQuerySkill_3", (String)"scmc-mobim-form", (Object[])new Object[0]);
            view.showErrorNotification(errMessage);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        String codeType = result.getCodeType();
        Object number = result.getAttribute("number");
        switch (codeType) {
            case "location": {
                Map warehouse;
                QFilter locationFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_location", (Long)orgId) != null ? BaseDataServiceHelper.getBaseDataFilter((String)"bd_location", (Long)orgId) : QFilterHelper.getIdentEqFilter();
                locationFilter.and(new QFilter("number", "=", number));
                locationFilter.and(new QFilter("org.id", "=", appHomeOrgId));
                List locationIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_location", (QFilter[])locationFilter.toArray(), null, (int)2);
                if (locationIds.size() == 1) {
                    showParameter.setCustomParam("flocationid", locationIds.get(0));
                }
                if (!(warehouse = (Map)result.getAttribute("warehouse")).isEmpty()) {
                    QFilter warehouseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)orgId) != null ? BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)orgId) : QFilterHelper.getIdentEqFilter();
                    warehouseFilter.and(new QFilter("number", "=", warehouse.get("number")));
                    List warehouseIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_warehouse", (QFilter[])warehouseFilter.toArray(), null, (int)2);
                    if (warehouseIds.size() == 1) {
                        showParameter.setCustomParam("fwarehouseid", warehouseIds.get(0));
                    }
                }
                this.showFormView(view, showParameter, appHomeOrgId);
                break;
            }
            case "material": {
                QFilter materialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
                materialFilter.and(new QFilter("number", "=", number));
                List materialIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])materialFilter.toArray(), null, (int)2);
                if (materialIds.size() == 1) {
                    showParameter.setCustomParam("fmaterialid", materialIds.get(0));
                }
                this.showFormView(view, showParameter, appHomeOrgId);
                break;
            }
            case "warehouse": {
                QFilter warehouseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)orgId);
                warehouseFilter.and(new QFilter("number", "=", number));
                List wareHouseIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_warehouse", (QFilter[])warehouseFilter.toArray(), null, (int)2);
                if (wareHouseIds.size() == 1) {
                    showParameter.setCustomParam("fwarehouseid", wareHouseIds.get(0));
                }
                this.showFormView(view, showParameter, appHomeOrgId);
                break;
            }
        }
    }

    public void showFormView(IFormView view, MobileFormShowParameter showParameter, Object appHomeOrgId) {
        showParameter.setCustomParam("orgid", appHomeOrgId);
        showParameter.setFormId("mobim_invquery");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)showParameter);
    }
}

