/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.op.skill;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.plugin.op.skill.ISkill;
import kd.scmc.msmob.pojo.QrCodeResult;

public class LocationTransferSkill
implements ISkill {
    public void handle(IFormView view, QrCodeResult qrCodeResult) {
        Object orgId = view.getFormShowParameter().getCustomParam("orgid");
        Long appHomeOrgId = Long.valueOf(String.valueOf(orgId));
        boolean orgFunction = OrgUnitServiceHelper.checkOrgFunction((Long)appHomeOrgId, (String)"05");
        if (!orgFunction) {
            String errMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u5e93\u5b58\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u5411\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"LocationTransferSkill_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            view.showErrorNotification(errMessage);
            return;
        }
        boolean isNewPerm = PermissionHelper.checkPermission((Long)appHomeOrgId, (String)"im", (String)"im_locationtransfer", (String)"47156aff000000ac");
        if (!isNewPerm) {
            String errMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u4ed3\u4f4d\u79fb\u52a8\u5355\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u5411\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"LocationTransferSkill_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            view.showErrorNotification(errMessage);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        String codeType = qrCodeResult.getCodeType();
        Object number = qrCodeResult.getAttribute("number");
        switch (codeType) {
            case "location": {
                Map warehouse;
                QFilter locationFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_location", (Long)appHomeOrgId) != null ? BaseDataServiceHelper.getBaseDataFilter((String)"bd_location", (Long)appHomeOrgId) : QFilterHelper.getIdentEqFilter();
                locationFilter.and(new QFilter("number", "=", number));
                locationFilter.and(new QFilter("org.id", "=", (Object)appHomeOrgId));
                List locationIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_location", (QFilter[])locationFilter.toArray(), null, (int)2);
                if (locationIds.size() == 1) {
                    showParameter.setCustomParam("locationId", locationIds.get(0));
                }
                if (!(warehouse = (Map)qrCodeResult.getAttribute("warehouse")).isEmpty()) {
                    QFilter warehouseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)appHomeOrgId) != null ? BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)appHomeOrgId) : QFilterHelper.getIdentEqFilter();
                    warehouseFilter.and(new QFilter("number", "=", warehouse.get("number")));
                    List warehouseIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_warehouse", (QFilter[])warehouseFilter.toArray(), null, (int)2);
                    if (warehouseIds.size() != 1) break;
                    showParameter.setCustomParam("warehouseId", warehouseIds.get(0));
                    break;
                }
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)appHomeOrgId) != null ? BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)appHomeOrgId) : QFilterHelper.getIdentEqFilter();
                qFilter.and("location.number", "=", number);
                List warehouseIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_warehouse", (QFilter[])qFilter.toArray(), null, (int)2);
                if (warehouseIds.isEmpty()) {
                    String errMsg = ResManager.loadKDString((String)"\u4ed3\u4f4d\u7f16\u7801\u4e3a%s,\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u3002", (String)"no_warehouse_location", (String)"scmc-msmob-form", (Object[])new Object[0]);
                    String format = String.format(errMsg, number);
                    view.showErrorNotification(format);
                    return;
                }
                showParameter.setCustomParam("warehouseId", warehouseIds.get(0));
                break;
            }
        }
        showParameter.setCustomParam("locationTransferSkill", (Object)true);
        showParameter.setCustomParam("billno", null);
        showParameter.setCustomParam("orgid", (Object)appHomeOrgId);
        showParameter.setCustomParam("billid", null);
        showParameter.setFormId("mobim_locationtransedit");
        showParameter.setCustomParam("mainOrg", (Object)appHomeOrgId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)showParameter);
    }
}

