/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.tpl.imtpl;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.business.helper.scan.ImBarCodeHandleHelper;
import kd.scmc.mobim.common.utils.BotpUtils;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.tpl.MobImBillBeforeF7Select;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryViewPlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.handler.ImBillEntryBillPropertyChangedHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;

public class MobImBillEntryEditPlugin
extends MobImBillEntryViewPlugin
implements BeforeF7SelectListener {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "qty", "unit", "qtyunit2nd", "unit2nd", "warehouse", "location", "producedate", "expirydate", "lotnumber", "org", "invscheme", "billid", "pcentitykey"};
    private static final String[] F7_FIELD_KEYS = new String[]{"warehouse", "location", "material"};
    private static final String[] BUTTON = new String[]{"warehousescan", "locationscan"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
        this.addClickListeners(BUTTON);
    }

    @Override
    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView storageView = this.getPcEntityStorageView();
        String pcEntityKey = this.getPcEntityKey();
        IFormView view = this.getView();
        BotpUtils.setEnableByBotp(view, storageView, pcEntityKey, "material");
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("warehousescan".equals(key) || "locationscan".equals(key)) {
            this.getPageCache().put("scan_key", key);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String code = codeStr == null ? "" : String.valueOf(codeStr);
            String scanKey = this.getView().getPageCache().get("scan_key");
            this.handleScan(scanKey, code);
        }
    }

    public void handleScan(String scanKey, String code) {
        DynamicObject org = this.getOrg();
        switch (scanKey) {
            case "warehousescan": {
                this.handleWarehouseScan(code, org);
                break;
            }
            case "locationscan": {
                this.handleLocationScan(code);
                break;
            }
        }
    }

    public void handleLocationScan(String code) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        QFilter locationFilter = this.getLocationFilter();
        Object locationId = ImBarCodeHandleHelper.getLocationIdByBarCode(code, warehouse, locationFilter);
        this.getModel().setValue("location", locationId);
        this.showScanSuccessTip();
    }

    public DynamicObject getOrg() {
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        return bill.getDynamicObject("org");
    }

    public void handleWarehouseScan(String code, DynamicObject org) {
        QFilter warehouseFilter = this.getWarehouseFilter();
        Object warehouseOrgId = ImBarCodeHandleHelper.getWarehouseIdByBarCode(this.getPcEntityKey(), code, org, warehouseFilter);
        this.getModel().setValue("warehouse", warehouseOrgId);
        this.showScanSuccessTip();
    }

    public void showScanSuccessTip() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u626b\u63cf\u6210\u529f\u3002", (String)"LocationTransferEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
    }

    public QFilter getWarehouseFilter() {
        return QFilterHelper.getIdentEqFilter();
    }

    public QFilter getLocationFilter() {
        return QFilterHelper.getIdentEqFilter();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        MobImBillBeforeF7Select selector = new MobImBillBeforeF7Select(this.getView());
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        String pcEntityKey = this.getPcEntityKey();
        IPageCache pageCache = this.getView().getPageCache();
        int rowIndex = Integer.parseInt(pageCache.get("row"));
        selector.beforeF7Select(e, pcEntityKey, rowIndex, bill);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.registerPropertyChangedHandler(new ImBillEntryBillPropertyChangedHandler(this.getView(), this.getPcEntityKey()));
        super.propertyChanged(e);
    }
}

