/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.tpl.imtpl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.scmc.mobim.business.helper.InverseBillHelper;
import kd.scmc.mobim.business.helper.VisibleAbilityHelper;
import kd.scmc.mobim.common.utils.DateUtils;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;

public class MobImBillEntryViewPlugin
extends EntryEditTplPlugin {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "unit", "qty", "qtyunit2nd", "unit2nd", "warehouse", "location", "producedate", "expirydate", "org", "invscheme", "billid", "pcentitykey", "lotnumber"};
    private static final String[] QTY_TYPE_FIELDS = new String[]{"qty", "qtyunit2nd"};
    private VisibleAbilityHelper setVisibleAbilityHelper;

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void initialize() {
        super.initialize();
        this.setVisibleAbilityHelper = new VisibleAbilityHelper(this.getView(), this.getModel());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setColumnsColor();
        DynamicObject bill = this.getBill();
        if (bill == null) {
            return;
        }
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        if (billEntry == null || billEntry.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        BigDecimal qtyUnit2nd = (BigDecimal)model.getValue("qtyunit2nd");
        qtyUnit2nd = qtyUnit2nd == null ? qtyUnit2nd : qtyUnit2nd.abs();
        model.beginInit();
        model.setValue("qtyunit2nd", (Object)qtyUnit2nd);
        model.endInit();
        this.getView().updateView("qtyunit2nd");
        this.setParentValue("qtyunit2nd", qtyUnit2nd);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleAbilityHelper.setVisibleAbility();
    }

    private void setColumnsColor() {
        IFormView view = this.getView();
        boolean isInverseBill = this.isInverseBill();
        InverseBillHelper.setHeadColumsColor(view, QTY_TYPE_FIELDS, isInverseBill);
    }

    private boolean isInverseBill() {
        return InverseBillHelper.judgeIsInverseBillByPcEntity(EntityCacheHelper.getPcEntityFromCache((IMobilePage)this));
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.setVisibleAbilityHelper.setVisibleAbility();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "materialLifeDate": {
                this.materialDateChangedConfirmCallBack(result, e.getCustomVaule());
                break;
            }
        }
    }

    private void materialDateChangedConfirmCallBack(MessageBoxResult result, String customValue) {
        Map dateChangedConfirmMap = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        Date newExpiryDate = DateUtils.parseShortDate((String)dateChangedConfirmMap.get("newExpiryDate"), false);
        Date newProduceDate = DateUtils.parseShortDate((String)dateChangedConfirmMap.get("newProduceDate"), false);
        int changedRowIndex = (Integer)dateChangedConfirmMap.get("changedRowIndex");
        boolean confirmed = MessageBoxResult.Yes.equals((Object)result);
        DataChangedHandlerHelper.setEntryValueManual((AbstractMobFormPlugin)this, (String)this.getPcEntityKey(), (int)changedRowIndex, (pcEntityFromCache, changedEntry) -> {
            changedEntry.set("expirydate", (Object)(confirmed ? newExpiryDate : null));
            changedEntry.set("producedate", (Object)(confirmed ? newProduceDate : null));
        });
    }
}

