/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.tpl.imtpl;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.scmc.mobim.business.helper.InverseBillHelper;
import kd.scmc.mobim.common.utils.BotpUtils;
import kd.scmc.mobim.common.utils.MetaUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;

public class MobImBillInfoPlugin
extends MobPushTargetBillInfoPlugin
implements PagerClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entry = (CardEntry)this.getControl("entryentity");
        entry.addPagerClickListener((PagerClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean isDraw;
        super.afterCreateNewData(e);
        if (this.curData != null && this.curData.length > 0 && MetaUtils.isExistFieldKey(this.curData[0], "invscheme")) {
            Boolean isNegativeBill = InverseBillHelper.isRedBill(this.curData[0]);
            this.getPageCache().put("isNegativeBill", String.valueOf(isNegativeBill));
        }
        if (isDraw = this.isDrawByBotp()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentryop"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scanbtn"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scan"});
        }
    }

    protected boolean isDrawByBotp() {
        IFormView view = this.getView();
        String pcEntityKey = this.getPcEntityKey();
        return BotpUtils.isDrawByBotp(view, pcEntityKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setColumnColor();
    }

    public void pagerClick(PagerClickEvent e) {
        IPageCache pageCache = this.getPageCache();
        int pageSize = e.getPageRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        int totalRows = entity.size();
        int currPageNum = e.getCurrentPageIndex();
        int startRowIndex = pageSize * (currPageNum - 1);
        int endRowSeq = startRowIndex + pageSize > totalRows ? totalRows : startRowIndex + pageSize;
        int endRowIndex = endRowSeq - 1;
        HashSet<String> negativeNumColumns = new HashSet<String>(16);
        HashSet<String> entryColumns = new HashSet<String>(16);
        entryColumns.add("qty");
        entryColumns.add("qtyunit2nd");
        negativeNumColumns.add("qty");
        negativeNumColumns.add("qtyunit2nd");
        String isNegative = pageCache.get("isNegativeBill");
        boolean isNegativeBill = StringUtils.isNotEmpty((CharSequence)isNegative) && isNegative.equals("true");
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        InverseBillHelper.handleEntryInverseColumn(this.getView(), pcEntityKey, entryColumns, negativeNumColumns, isNegativeBill, startRowIndex, endRowIndex);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("viewCallBack".equals(e.getActionId()) || "callback".equals(e.getActionId())) {
            this.setColumnColor();
        }
    }

    private void setColumnColor() {
        DynamicObject bill;
        DynamicObject dynamicObject = bill = this.curData == null || this.curData.length == 0 ? null : this.curData[0];
        if (bill == null) {
            bill = this.getBill();
        }
        if (bill == null) {
            return;
        }
        Set<String> headColumns = Collections.singleton("billno");
        HashSet<String> negativeNumColumns = new HashSet<String>(16);
        HashSet<String> entryColumns = new HashSet<String>(16);
        entryColumns.add("qty");
        entryColumns.add("qtyunit2nd");
        negativeNumColumns.add("qty");
        negativeNumColumns.add("qtyunit2nd");
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        InverseBillHelper.handleInverseColumnByPcEntity(this.getView(), pcEntityKey, bill, headColumns, entryColumns, negativeNumColumns);
    }
}

