/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.tpl.imtpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scmc.mobim.business.webservicehelper.SpeechRecognitionHelper;
import kd.scmc.mobim.common.utils.RegExpUtils;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillListTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;

public class MobImBillListPlugin
extends MobBillListTplPlugin {
    private static final Log LOG = LogFactory.getLog(MobImBillListPlugin.class);
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    protected String[] paramKey = new String[]{"org", "warehouse", "material"};
    protected String[] filterKey = new String[]{"org.name", "billentry.warehouse.name", "billentry.material.masterid.name"};
    protected String[] entityKey = new String[]{"bos_org", "bd_warehouse", "bd_material"};

    public void setDefaultDate() {
        super.setDefaultDate();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object toDoDate = param.getCustomParam("todoDate");
        if ("todoDate".equals(toDoDate)) {
            this.setToDoBizDateRange();
            this.getModel().setValue("combofield", (Object)"B");
        }
        if (param.getCustomParam(START_DATE) == null || param.getCustomParam(END_DATE) == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date startDate = sdf.parse((String)param.getCustomParam(START_DATE));
            Date endDate = sdf.parse((String)param.getCustomParam(END_DATE));
            this.getModel().setValue("daterangefield_startdate", (Object)startDate);
            this.getModel().setValue("daterangefield_enddate", (Object)endDate);
        }
        catch (ParseException exception) {
            LOG.warn("\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0c\u4f7f\u7528\u6a21\u677f\u9ed8\u8ba4\u65e5\u671f\u8fc7\u6ee4\u3002\u5f02\u5e38\u5f00\u59cb\u65f6\u95f4\uff1a" + param.getCustomParam(START_DATE) + "\u5f02\u5e38\u7ed3\u675f\u65f6\u95f4\uff1a" + param.getCustomParam(END_DATE));
        }
    }

    private void setToDoBizDateRange() {
        IDataModel model = this.getModel();
        Date currDate = new Date();
        Date endDateTime = DateUtils.getDayEndTime((Date)currDate);
        Date startDateTime = DateUtils.getStartTimeOfPastThreeMonths((Date)currDate);
        model.setValue("daterangefield_startdate", (Object)startDateTime);
        model.setValue("daterangefield_enddate", (Object)endDateTime);
    }

    protected Map<String, BillSortType> getSortMap() {
        Map sortMap = super.getSortMap();
        sortMap.put("biztime", BillSortType.DESC);
        sortMap.put("createtime", BillSortType.DESC);
        return sortMap;
    }

    public List<FilterCondition> getFilters() {
        List filters = super.getFilters();
        this.addFilters(filters);
        return filters;
    }

    private void addFilters(List<FilterCondition> qFilters) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        for (int i = 0; i < this.paramKey.length; ++i) {
            this.addFilterFromParam(param, qFilters, this.paramKey[i], this.filterKey[i], this.entityKey[i]);
        }
    }

    private void addFilterFromParam(MobileFormShowParameter param, List<FilterCondition> qFilters, String paramKey, String filterKey, String entityKey) {
        String key = (String)param.getCustomParam(paramKey);
        if (!StringUtils.isEmpty((String)key) && RegExpUtils.isNumber(key)) {
            FilterCondition filterCondition = new FilterCondition(filterKey, "=", (Object)SpeechRecognitionHelper.getFilterParamName(key, entityKey));
            qFilters.add(filterCondition);
        }
    }
}

