/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.tpl.imtpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.form.events.MobFilterSortInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.scmc.mobim.business.webservicehelper.SpeechRecognitionHelper;
import kd.scmc.mobim.common.utils.RegExpUtils;

public class MobImOldBillListPlugin
extends AbstractMobListPlugin {
    private static final Log LOG = LogFactory.getLog(MobImOldBillListPlugin.class);
    private static final String ORG_FROM_PARENT = "orgBillNo";
    private static final String ORG_NUM = "org.number";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    protected String[] paramKey = new String[]{"orgBillNo", "org", "warehouse", "material"};
    protected String[] filterKey = new String[]{"org.number", "org.name", "billentry.warehouse.name", "billentry.material.masterid.name"};
    protected String[] entityKey = new String[]{"bos_org", "bos_org", "bd_warehouse", "bd_material"};

    public void mobFilterSortInit(MobFilterSortInitArgs args) {
        super.mobFilterSortInit(args);
        MobileListShowParameter param = (MobileListShowParameter)this.getView().getFormShowParameter();
        if (param.getCustomParam(START_DATE) == null || param.getCustomParam(END_DATE) == null) {
            return;
        }
        args.getFilterColumn("biztime").setDefaultValues(new Object[]{param.getCustomParam(START_DATE), param.getCustomParam(END_DATE)});
    }

    public void setFilter(SetFilterEvent e) {
        MobileListShowParameter param = (MobileListShowParameter)this.getView().getFormShowParameter();
        List qFilters = e.getQFilters();
        this.addDateFilter(param, qFilters);
        for (int i = 0; i < this.paramKey.length; ++i) {
            this.addFilterFromParam(param, qFilters, this.paramKey[i], this.filterKey[i], this.entityKey[i]);
        }
    }

    private void addFilterFromParam(MobileListShowParameter param, List<QFilter> filters, String paramKey, String filterKey, String entityKey) {
        String key = (String)param.getCustomParam(paramKey);
        if (!StringUtils.isEmpty((String)key)) {
            if (ORG_FROM_PARENT.equals(paramKey)) {
                filters.add(new QFilter(filterKey, "=", (Object)key));
            } else if (RegExpUtils.isNumber(key)) {
                filters.add(new QFilter(filterKey, "=", (Object)SpeechRecognitionHelper.getFilterParamName(key, entityKey)));
            }
        }
    }

    private void addDateFilter(MobileListShowParameter param, List<QFilter> filters) {
        if (param.getCustomParam(START_DATE) == null || param.getCustomParam(END_DATE) == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date startDate = sdf.parse((String)param.getCustomParam(START_DATE));
            Date endDate = sdf.parse((String)param.getCustomParam(END_DATE));
            QFilter startBizTime = new QFilter("biztime", ">=", (Object)startDate);
            QFilter endBizTime = new QFilter("biztime", "<=", (Object)endDate);
            filters.addAll(Arrays.asList(startBizTime, endBizTime));
        }
        catch (ParseException e) {
            LOG.warn("\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0c\u672a\u6839\u636e\u65e5\u671f\u8fc7\u6ee4\u3002\u5f00\u59cb\u65f6\u95f4\uff1a" + param.getCustomParam(START_DATE) + "\u7ed3\u675f\u65f6\u95f4\uff1a" + param.getCustomParam(END_DATE));
        }
    }
}

