/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.tpl.imtpl.handler;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.mobim.business.helper.ImBillCalculateHelper;
import kd.scmc.mobim.business.helper.ShowExpiryDateConfirmHelper;
import kd.scmc.mobim.common.utils.DateUtils;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.pojo.ChangedField;

public class ImBillEntryBillPropertyChangedHandler
implements IPropertyChangedHandler {
    private IFormView view;
    private String pcFieldName;

    public ImBillEntryBillPropertyChangedHandler(IFormView view, String pcFieldName) {
        this.view = view;
        this.pcFieldName = pcFieldName;
    }

    public void onPropertyChanged(PropertyChangedContext context) {
        boolean main = context.isMain();
        if (main) {
            return;
        }
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        String pcFieldName = context.getPcFieldName();
        DynamicObject pcEntity = context.getChangePcData();
        switch (pcFieldName) {
            case "warehouse": {
                pcEntity.set("location", null);
                break;
            }
            case "producedate": {
                this.onProduceDateChanged(context);
                break;
            }
            case "expirydate": {
                this.onExpireDateChanged(context);
                break;
            }
            case "qty": 
            case "qtyunit2nd": {
                this.changeQty(context);
                break;
            }
        }
    }

    private void changeQty(PropertyChangedContext context) {
        DynamicObject calculatedResult = context.getCalculatedResult();
        String pcFieldName = context.getPcFieldName();
        BigDecimal newValue = (BigDecimal)context.getNewValue();
        BigDecimal oldValue = (BigDecimal)context.getOldValue();
        int rowIndex = context.getRowIndex();
        DynamicObjectCollection entryList = calculatedResult.getDynamicObjectCollection(context.getPcEntryName());
        DynamicObject changeEntry = (DynamicObject)entryList.get(context.getRowIndex());
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(newValue) > 0) {
            changeEntry.set(pcFieldName, (Object)oldValue);
            context.setNewValue((Object)oldValue);
            return;
        }
        IDataModel model = this.view.getModel();
        if ("qty".equals(pcFieldName)) {
            changeEntry.set("qtyunit2nd", model.getValue("qtyunit2nd"));
        } else if ("qtyunit2nd".equals(pcFieldName)) {
            changeEntry.set("qty", model.getValue("qty"));
        }
        changeEntry.set(pcFieldName, (Object)newValue);
        ChangedField entryPropArgs = new ChangedField(pcFieldName, rowIndex);
        calculatedResult = ImBillCalculateHelper.calcMainEntry(calculatedResult, Collections.singletonList(entryPropArgs));
        context.setCalculatedResult(calculatedResult);
    }

    private void onProduceDateChanged(PropertyChangedContext context) {
        Date oldProduceDate = (Date)context.getOldValue();
        Date newProduceDate = (Date)context.getNewValue();
        if (newProduceDate == null) {
            return;
        }
        int rowIndex = context.getRowIndex();
        DynamicObject calculatedResult = context.getCalculatedResult();
        DynamicObject changedEntry = (DynamicObject)calculatedResult.getDynamicObjectCollection(context.getPcEntryName()).get(rowIndex);
        DynamicObject material = changedEntry.getDynamicObject("material");
        Date oldExpiryDate = (Date)changedEntry.get("expirydate");
        if (material == null || !material.getBoolean("enableshelflifemgr")) {
            return;
        }
        String shelfLifeUnit = material.getString("shelflifeunit");
        int shelfLife = material.getInt("shelflife");
        String calculationForEndDate = material.getString("calculationforenddate");
        String caldirection = material.getString("caldirection");
        Date expiryDateCalculateResult = oldExpiryDate;
        if (CalDirectionEnum.CALBOTH.getValue().equals(caldirection) || CalDirectionEnum.CALENDDATE.getValue().equals(caldirection)) {
            expiryDateCalculateResult = ShelfLifeDateUtil.shelflifeDateCal((String)shelfLifeUnit, (int)shelfLife, (Date)newProduceDate, (String)calculationForEndDate);
        }
        if (expiryDateCalculateResult == null) {
            changedEntry.set("producedate", (Object)newProduceDate);
            return;
        }
        if (expiryDateCalculateResult.before(newProduceDate)) {
            String newExpiryDateStr = DateUtils.getDateToString(expiryDateCalculateResult, false);
            String newProduceDateStr = DateUtils.getDateToString(newProduceDate, false);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7684\u7269\u6599\u3010%2$s\u3011\u6839\u636e\u751f\u4ea7\u65e5\u671f\u8ba1\u7b97\u51fa\u7684\u5230\u671f\u65e5\u671f\u3010%3$s\u3011\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u3010%4$s\u3011\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\uff0c\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"MobImBillEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]), rowIndex + 1, material.get("masterid.name"), newExpiryDateStr, newProduceDateStr);
            this.view.showErrorNotification(msg);
            changedEntry.set("producedate", null);
            return;
        }
        ShowExpiryDateConfirmHelper showExpiryDateConfirmHelper = new ShowExpiryDateConfirmHelper(this.view, this.pcFieldName);
        showExpiryDateConfirmHelper.showExpiryDateConfirm(rowIndex, material, oldExpiryDate, expiryDateCalculateResult, oldProduceDate, newProduceDate, changedEntry);
    }

    private void onExpireDateChanged(PropertyChangedContext context) {
        Date oldExpireDate = (Date)context.getOldValue();
        Date newExpireDate = (Date)context.getNewValue();
        if (newExpireDate == null) {
            return;
        }
        int rowIndex = context.getRowIndex();
        DynamicObject calculatedResult = context.getCalculatedResult();
        DynamicObject changedEntry = (DynamicObject)calculatedResult.getDynamicObjectCollection(context.getPcEntryName()).get(rowIndex);
        Date oldProduceDate = (Date)changedEntry.get("producedate");
        DynamicObject material = (DynamicObject)changedEntry.get("material");
        if (material == null || !material.getBoolean("enableshelflifemgr")) {
            return;
        }
        String shelflifeUnit = material.getString("shelflifeunit");
        int shelfLife = material.getInt("shelflife");
        String calculationForEndDate = material.getString("calculationforenddate");
        String caldirection = material.getString("caldirection");
        Date produceDate = oldProduceDate;
        if ((CalDirectionEnum.CALBOTH.getValue().equals(caldirection) || CalDirectionEnum.CALSTARTDATE.getValue().equals(caldirection)) && !"2".equals(calculationForEndDate)) {
            produceDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelfLife), (Date)newExpireDate, (String)calculationForEndDate);
        }
        if (produceDate != null && newExpireDate.before(produceDate)) {
            String newExpiryDateStr = DateUtils.getDateToString(newExpireDate, false);
            String newProduceDateStr = DateUtils.getDateToString(produceDate, false);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7684\u7269\u6599\u3010%2$s\u3011\u6839\u636e\u751f\u4ea7\u65e5\u671f\u8ba1\u7b97\u51fa\u7684\u5230\u671f\u65e5\u671f\u3010%3$s\u3011\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u3010%4$s\u3011\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\uff0c\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"MobImBillEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]), rowIndex + 1, material.get("masterid.name"), newExpiryDateStr, newProduceDateStr);
            this.view.showErrorNotification(msg);
            changedEntry.set("expirydate", null);
            return;
        }
        ShowExpiryDateConfirmHelper showExpiryDateConfirmHelper = new ShowExpiryDateConfirmHelper(this.view, this.pcFieldName);
        showExpiryDateConfirmHelper.showExpiryDateConfirm(rowIndex, material, oldExpireDate, newExpireDate, oldProduceDate, produceDate, changedEntry);
    }
}

