/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.report.invbillage;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.scmc.mobim.business.helper.InvBillAgeReportHelper;
import kd.scmc.mobim.common.utils.QuantityUtils;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.utils.PageUtils;

public class AgeReportDetailPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static final String SCHEME_ID = "schemeId";
    private static final String MATERIAL_ID = "materialId";
    private static final String BAR_CHART_LABEL = "barChartLabel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_NUM = "num";
    private static final String ENTRY_MATERIAL = "material";
    private static final String ENTRY_BASEQTY = "baseqty";
    private static final String ENTRY_BASE_UNIT = "baseunit";
    private static final String ORG = "org";
    private static final String INV_AGE_GROUP = "invagegroup";
    private static final String NAME_SORT = "namesort";
    private static final String QTY_SORT = "qtysort";
    private static final String NAME_SORT_BTN = "namesortbtn";
    private static final String QTY_SORT_BTN = "qtysortbtn";
    private static final String ASC = "asc";
    private static final String DESC = "desc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NAME_SORT_BTN, QTY_SORT_BTN});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object schemeId = formShowParameter.getCustomParam(SCHEME_ID);
        Object groupLabel = formShowParameter.getCustomParam(BAR_CHART_LABEL);
        this.getPageCache().put(NAME_SORT, ASC);
        this.getPageCache().put(QTY_SORT, DESC);
        this.initData(schemeId, groupLabel);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "namesortbtn": {
                this.nameSort();
                break;
            }
            case "qtysortbtn": {
                this.qtySort();
                break;
            }
        }
    }

    private void nameSort() {
        String sort = this.getPageCache().get(NAME_SORT);
        this.sort(NAME_SORT, sort);
    }

    private void qtySort() {
        String sort = this.getPageCache().get(QTY_SORT);
        this.sort(QTY_SORT, sort);
    }

    private void sort(String key, String sort) {
        if (ASC.equals(sort)) {
            this.getPageCache().put(key, DESC);
        } else {
            this.getPageCache().put(key, ASC);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object schemeId = formShowParameter.getCustomParam(SCHEME_ID);
        Object groupLabel = formShowParameter.getCustomParam(BAR_CHART_LABEL);
        this.initData(schemeId, groupLabel);
    }

    public void entryRowClick(RowClickEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control source = (Control)evt.getSource();
        String entryKey = source.getKey();
        if (entryKey.equals(ENTRY_ENTITY)) {
            int rowIndex = evt.getRow();
            DynamicObject material = (DynamicObject)model.getValue(ENTRY_MATERIAL, rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue(ENTRY_BASE_UNIT, rowIndex);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object schemeId = formShowParameter.getCustomParam(SCHEME_ID);
            HashMap<String, Object> customParams = new HashMap<String, Object>(3);
            customParams.put(SCHEME_ID, schemeId);
            customParams.put(MATERIAL_ID, material.getPkValue());
            String dataGroup = this.getPageCache().get(String.valueOf(rowIndex));
            String group = this.getPageCache().get(INV_AGE_GROUP);
            customParams.put(INV_AGE_GROUP, group);
            customParams.put("intervaldays", dataGroup);
            customParams.put(ENTRY_BASE_UNIT, unit.getPkValue());
            PageUtils.showFormPage((IFormView)view, (String)"mobim_materialrptdetail", customParams, null);
        }
    }

    public void initData(Object schemeId, Object groupLabel) {
        DynamicObject scheme = SchemeOpHelper.getSingleScheme((Long)Long.valueOf(String.valueOf(schemeId)));
        DynamicObject filterDyn = InvBillAgeReportHelper.getDynamicObjectByScheme(scheme);
        DynamicObject org = filterDyn.getDynamicObject("orghead");
        this.getModel().setValue(ORG, (Object)org);
        this.getModel().setValue(INV_AGE_GROUP, groupLabel);
        ReportQueryParam queryParam = InvBillAgeReportHelper.getReportQueryParam(filterDyn);
        List<String> groups = InvBillAgeReportHelper.getGroups(filterDyn);
        this.getPageCache().put(INV_AGE_GROUP, JSON.toJSONString(groups));
        int labels = groups.size();
        int groupLabelIndex = 0;
        for (int i = 0; i < labels; ++i) {
            String name = groups.get(i);
            if (!name.equals(groupLabel)) continue;
            groupLabelIndex = i;
            break;
        }
        DataSet queryDataSet = InvBillAgeReportHelper.query(queryParam);
        IDataModel model = this.getModel();
        if (queryDataSet != null && !queryDataSet.isEmpty()) {
            String nameSort = this.getPageCache().get(NAME_SORT);
            String qtySort = this.getPageCache().get(QTY_SORT);
            DataSet dataSet = queryDataSet.copy().orderBy(new String[]{"material " + nameSort, "baseqtyrang" + groupLabelIndex + " " + qtySort});
            model.deleteEntryData(ENTRY_ENTITY);
            model.batchCreateNewEntryRow(ENTRY_ENTITY, dataSet.copy().count(ENTRY_MATERIAL, false));
            int index = 0;
            for (Row row : dataSet) {
                Long materialId = row.getLong(ENTRY_MATERIAL);
                BigDecimal baseQty = row.getBigDecimal("baseqtyrang" + groupLabelIndex);
                Long unitId = row.getLong(ENTRY_BASE_UNIT);
                ArrayList<BigDecimal> qtyList = new ArrayList<BigDecimal>(labels);
                for (int i = 0; i < labels; ++i) {
                    BigDecimal qty = row.getBigDecimal("baseqtyrang" + i);
                    qtyList.add(qty);
                }
                this.getPageCache().put(String.valueOf(index), JSON.toJSONString(qtyList));
                model.setValue(ENTRY_MATERIAL, (Object)materialId, index);
                BigDecimal qty = baseQty.stripTrailingZeros();
                model.setValue(ENTRY_BASEQTY, (Object)QuantityUtils.addSeparator(qty), index);
                model.setValue(ENTRY_BASE_UNIT, (Object)unitId, index);
                model.setValue(ENTRY_NUM, (Object)(index + 1), index);
                ++index;
            }
        } else {
            model.deleteEntryData(ENTRY_ENTITY);
        }
        this.getView().updateView();
    }
}

