/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.report.invbillage;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.enums.SchemeEnum;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.common.utils.PropertyValueUtils;
import kd.scmc.msmob.report.filter.MobReportFilterTplPlugin;
import org.apache.commons.lang3.StringUtils;

public class InvBillAgeReportFilterPlugin
extends MobReportFilterTplPlugin
implements BeforeF7SelectListener {
    private static final String NUM = "1";
    private static final String ADD_LABEL = "addlabel";
    private static final String ADD_VECTOR = "addvector";
    private static final String DEL_VECTOR = "delvector";
    private static final String SCHEME_BTN = "schemebtn";
    private static final String SAVE_BTN = "savebtn";
    private static final String QUERY_BTN = "querybtn";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SCHEME_ID = "schemeId";
    private static final String FORM_KEY = "formKey";
    private static final String SAVE_SCHEME = "savescheme";
    private static final String NAME = "name";
    private static final String SCHEME_TYPE = "schemetype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_LABEL, ADD_VECTOR, DEL_VECTOR, SCHEME_BTN, SAVE_BTN, QUERY_BTN});
        FormUtils.addF7Listener(this, "orghead", "materialgroupstandard");
    }

    public void initialize() {
        super.initialize();
        OrgEdit orgF7 = (OrgEdit)this.getControl("orghead");
        orgF7.setOrgFunc("15");
    }

    public void afterCreateNewData(EventObject e) {
        this.initScheme();
        this.setVisible();
    }

    private void initScheme() {
        DynamicObject group;
        DynamicObject filterDyn;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object schemeId = formShowParameter.getCustomParam(SCHEME_ID);
        DynamicObject schemeDyn = SchemeOpHelper.getSingleScheme((Long)Long.valueOf(String.valueOf(schemeId)));
        this.getPageCache().put(SCHEME_ID, String.valueOf(schemeId));
        this.getPageCache().put(NAME, schemeDyn.getString("schemename"));
        String scheme = schemeDyn.getString("content_tag");
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        if (StringUtils.isNotEmpty((CharSequence)scheme)) {
            Object[] filterDyns = DynamicObjectSerializeUtil.deserialize((String)scheme, (DynamicObjectType)dataEntityType);
            filterDyn = (DynamicObject)filterDyns[0];
        } else {
            filterDyn = new DynamicObject((DynamicObjectType)dataEntityType);
        }
        IDataModel model = this.getModel();
        DynamicObject org = filterDyn.getDynamicObject("orghead");
        if (org != null) {
            model.setValue("orghead", org.getPkValue());
        }
        if ((group = filterDyn.getDynamicObject("materialgroupstandard")) != null) {
            model.setValue("materialgroupstandard", group.getPkValue());
        }
        model.setValue("enddate", (Object)filterDyn.getDate("enddate"));
        model.setValue("ageanalysis", filterDyn.get("ageanalysis"));
        DynamicObjectCollection entry = filterDyn.getDynamicObjectCollection(ENTRY_ENTITY);
        int size = entry.size();
        if (size > 1) {
            model.batchCreateNewEntryRow(ENTRY_ENTITY, size - 1);
        }
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entry.get(i);
            model.setValue("intervaldays", dyn.get("intervaldays"), i);
            model.setValue("invagegroup", dyn.get("invagegroup"), i);
            model.setValue("groupname", dyn.get("groupname"), i);
        }
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_ENTITY);
        cardEntry.setChildEnable(false, 0, new String[]{DEL_VECTOR});
    }

    private void setVisible() {
        Object value = this.getModel().getValue("ageanalysis");
        this.getView().setVisible(Boolean.FALSE, new String[]{"enddate"});
        if (NUM.equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"enddate"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "orghead": {
                InvBillAgeReportFilterPlugin.beforeF7SelectOrg(e);
                break;
            }
            case "materialgroupstandard": {
                this.beforeMaterialGroupStandard(e);
                break;
            }
        }
    }

    private void beforeMaterialGroupStandard(BeforeF7SelectEvent e) {
        Object org = this.getModel().getValue("orghead");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_3", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", ((DynamicObject)org).getPkValue(), Boolean.TRUE});
        List customFilters = e.getCustomQFilters();
        customFilters.add(new QFilter("id", "in", (Object)ids));
    }

    public static void beforeF7SelectOrg(BeforeF7SelectEvent e) {
        List permissionOrg = NewInvOrgHelper.getPermissionOrgs((String)"im_invagereport");
        if (permissionOrg == null || permissionOrg.isEmpty()) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
        }
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)"im_invagereport");
        if (orgIdList == null || orgIdList.length == 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
        }
        FormShowParameter showParameter = e.getFormShowParameter();
        showParameter.setCustomParam("range", (Object)orgIdList);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block8: for (int i = 0; i < valueSet.length; ++i) {
            if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) continue;
            Object newValue = valueSet[i].getNewValue();
            switch (propName) {
                case "ageanalysis": {
                    this.ageAnalysisChange(newValue);
                    continue block8;
                }
                case "intervaldays": {
                    this.intervalDaysChange(newValue);
                    continue block8;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "addlabel": 
            case "addvector": {
                this.addRow();
                break;
            }
            case "delvector": {
                this.delRow();
                break;
            }
            case "savebtn": {
                this.saveOp();
                break;
            }
            case "schemebtn": {
                this.schemeOp();
                break;
            }
            case "querybtn": {
                this.queryOp();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "savescheme": {
                this.saveScheme(closedCallBackEvent);
                break;
            }
        }
    }

    private void queryOp() {
        DynamicObject entity;
        String name = this.getPageCache().get(NAME);
        boolean isTrue = this.checkFilter(name, entity = this.getModel().getDataEntity(true), true);
        if (isTrue) {
            String description = this.handleDescription(entity);
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            DynamicObject bosOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            DynamicObject org = entity.getDynamicObject("orghead");
            bosOrg.set("id", org.getPkValue());
            bosOrg.set(NAME, org.get(NAME));
            entity.set("orghead", (Object)bosOrg);
            DynamicObject materialGroup = BusinessDataServiceHelper.newDynamicObject((String)"bd_materialgroupstandard");
            DynamicObject group = entity.getDynamicObject("materialgroupstandard");
            materialGroup.set("id", group.getPkValue());
            materialGroup.set(NAME, group.get(NAME));
            materialGroup.set("number", group.get("number"));
            materialGroup.set("masterid", group.get("masterid"));
            entity.set("materialgroupstandard", (Object)materialGroup);
            String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{entity}, (DynamicObjectType)dataEntityType);
            SchemeOpHelper.saveRecentScheme((String)this.getReportFormKey(), (String)content, (String)description);
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            formShowParameter.setFormId("mobim_invbillage_report");
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private void schemeOp() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("msmob_scheme_list");
        String schemeId = this.getPageCache().get(SCHEME_ID);
        if (StringUtils.isNotEmpty((CharSequence)schemeId)) {
            formShowParameter.setCustomParam(SCHEME_ID, (Object)Long.valueOf(schemeId));
        }
        formShowParameter.setCustomParam(FORM_KEY, (Object)"mobim_invbillagefilter");
        formShowParameter.setCustomParam(SCHEME_TYPE, (Object)this.getReportFormKey());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void saveOp() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mob_save_scheme");
        String name = this.getPageCache().get(NAME);
        formShowParameter.setCustomParam(NAME, (Object)name);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SAVE_SCHEME);
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void saveScheme(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject entity;
        String name;
        boolean isTrue;
        String confirm = NUM;
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        String type = (String)returnData.get("type");
        if (confirm.equals(type) && (isTrue = this.checkFilter(name = (String)returnData.get(NAME), entity = this.getModel().getDataEntity(true), false))) {
            String description = this.handleDescription(entity);
            DynamicObject bosOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            DynamicObject org = entity.getDynamicObject("orghead");
            bosOrg.set("id", org.getPkValue());
            bosOrg.set(NAME, org.get(NAME));
            entity.set("orghead", (Object)bosOrg);
            DynamicObject materialGroup = BusinessDataServiceHelper.newDynamicObject((String)"bd_materialgroupstandard");
            DynamicObject group = entity.getDynamicObject("materialgroupstandard");
            materialGroup.set("id", group.getPkValue());
            materialGroup.set(NAME, group.get(NAME));
            materialGroup.set("number", group.get("number"));
            materialGroup.set("masterid", group.get("masterid"));
            entity.set("materialgroupstandard", (Object)materialGroup);
            String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{entity}, (DynamicObjectType)entity.getDynamicObjectType());
            Long id = SchemeOpHelper.saveScheme((String)this.getReportFormKey(), (String)name, (String)content, (String)description);
            this.getPageCache().put(SCHEME_ID, String.valueOf(id));
            this.getPageCache().put(NAME, name);
            String saveSuccess = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"save_success", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showSuccessNotification(saveSuccess);
        }
    }

    private String handleDescription(DynamicObject entity) {
        ArrayList<String> description = new ArrayList<String>(5);
        String ageAnalysis = entity.getString("ageanalysis");
        if (NUM.equals(ageAnalysis)) {
            Date date = entity.getDate("enddate");
            String dateToString = DateUtils.getDateToString((Date)date, (boolean)false);
            String dateMsg = ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5e93\u5b58", (String)"InvBillAgeReportHelper_3", (String)"scmc-mobim-form", (Object[])new Object[0]);
            description.add(dateMsg + dateToString);
        } else {
            String msg = ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58", (String)"InvBillAgeReportFilterPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            description.add(msg);
        }
        DynamicObject org = entity.getDynamicObject("orghead");
        description.add(org.getString(NAME));
        DynamicObject materialGroup = entity.getDynamicObject("materialgroupstandard");
        description.add(materialGroup.getString(NAME));
        DynamicObjectCollection entry = entity.getDynamicObjectCollection(ENTRY_ENTITY);
        int count = entry.size() + 1;
        String groupsMsg = ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\u5171%s\u7ec4", (String)"InvBillAgeReportHelper_4", (String)"scmc-mobim-form", (Object[])new Object[0]);
        String group = String.format(groupsMsg, count);
        description.add(group);
        return StringUtils.join(description, (String)";");
    }

    private boolean checkFilter(String name, DynamicObject entity, boolean isSystemName) {
        Date date;
        if (StringUtils.isBlank((CharSequence)name)) {
            String msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        if (!isSystemName && SchemeEnum.RECENT_SCHEME_NAME.getName().equals(name)) {
            String msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a'\u6700\u8fd1\u65b9\u6848'\u3002", (String)"InvBillAgeReportFilterPlugin_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        DynamicObject org = entity.getDynamicObject("orghead");
        if (org == null) {
            String msg = ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_3", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        String analysis = entity.getString("ageanalysis");
        if (StringUtils.isBlank((CharSequence)analysis)) {
            String msg = ResManager.loadKDString((String)"\u5e93\u9f84\u5206\u6790\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_10", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        if (NUM.equals(analysis) && (date = entity.getDate("enddate")) == null) {
            String msg = ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_4", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        DynamicObject material = entity.getDynamicObject("materialgroupstandard");
        if (material == null) {
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u6807\u51c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_5", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        DynamicObjectCollection entry = entity.getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Integer> days = new ArrayList<Integer>(entry.size());
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entry.get(i);
            int day = dyn.getInt("intervaldays");
            if (day != 0) continue;
            days.add(i + 1);
        }
        if (!days.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\u8bbe\u7f6e\u4e2d\u7b2c\u3010%s\u3011\u5206\u5f55\u884c\uff0c\u95f4\u9694\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_6", (String)"scmc-mobim-form", (Object[])new Object[0]);
            String error = String.format(msg, StringUtils.join(days, (String)","));
            this.getView().showTipNotification(error);
            return false;
        }
        return true;
    }

    private void delRow() {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (index <= 0) {
            String errMsg = ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvBillAgeReportFilterPlugin_7", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        model.deleteEntryRow(ENTRY_ENTITY, index);
        this.recalculateEntry();
    }

    private void intervalDaysChange(Object newValue) {
        if (newValue == null || Integer.parseInt(String.valueOf(newValue)) == 0) {
            String errMsg = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeReportFilterPlugin_8", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        int max = 36500;
        int count = this.recalculateEntry();
        if (count > max) {
            String errMsg = ResManager.loadKDString((String)"\u95f4\u9694\u5929\u6570\u603b\u5171\u4e0d\u80fd\u5927\u4e8e36500\u5929\u3002", (String)"InvBillAgeReportFilterPlugin_9", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    private int recalculateEntry() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        int end = 0;
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            int day = entry.getInt("intervaldays");
            int start = end;
            end = day + end;
            if (day <= 0) break;
            String groupMsg = ResManager.loadKDString((String)"%1$s-%2$s\u5929", (String)"InvBillAgeReportHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            String invAgeGroup = String.format(groupMsg, start, end - 1);
            String nameMsg = ResManager.loadKDString((String)"\u5206\u7ec4%s", (String)"InvBillAgeReportHelper_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
            String groupName = String.format(nameMsg, i + 1);
            model.setValue("invagegroup", (Object)invAgeGroup, i);
            model.setValue("groupname", (Object)groupName, i);
            this.getView().updateView("invagegroup", i);
            this.getView().updateView("groupname", i);
        }
        return end;
    }

    private void addRow() {
        IDataModel model = this.getModel();
        int entryRow = model.createNewEntryRow(ENTRY_ENTITY);
        String nameMsg = ResManager.loadKDString((String)"\u5206\u7ec4%s", (String)"InvBillAgeReportHelper_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
        String groupName = String.format(nameMsg, entryRow + 1);
        model.setValue("groupname", (Object)groupName, entryRow);
    }

    private void ageAnalysisChange(Object newValue) {
        String value = String.valueOf(newValue);
        this.getView().setVisible(Boolean.FALSE, new String[]{"enddate"});
        if (NUM.equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"enddate"});
        }
    }

    public String getReportFormKey() {
        return "invBillAgeReport";
    }
}

