/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.report.invbillage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.mobim.business.helper.InvBillAgeReportHelper;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.report.form.MobReportTplPlugin;
import org.apache.commons.lang3.StringUtils;

public class InvBillAgeReportPlugin
extends MobReportTplPlugin {
    private static final String SCHEME_LABEL = "schemelabel";
    private static final String SCHEME_VECTOR = "schemevector";
    private static final String SET_UP_LABEL = "setuplabel";
    private static final String SET_UP_VECTOR = "setupvector";
    private static final String FILTER_CONDITION = "filtercondition";
    private static final String BAR_CHART = "barchart";
    private static final String SCHEME_ID = "schemeId";
    private static final String bar_chart_Label = "barChartLabel";
    private static final String FORM_KEY = "formKey";
    private static final String CHOOSE_SCHEME = "chooseScheme";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SCHEME_LABEL, SCHEME_VECTOR, SET_UP_LABEL, SET_UP_VECTOR});
        Chart barChartAp = (Chart)this.getView().getControl(BAR_CHART);
        barChartAp.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)this.getReportFormKey());
        this.initData(scheme);
    }

    private void initData(DynamicObject scheme) {
        kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl(SCHEME_LABEL);
        label.setText(scheme.getString("schemename"));
        this.getModel().setValue(FILTER_CONDITION, (Object)scheme.getString("description"));
        this.getModel().setValue(SCHEME_ID, scheme.getPkValue());
        this.buildBarChart(scheme);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "schemelabel": 
            case "schemevector": {
                this.chooseScheme();
                break;
            }
            case "setuplabel": 
            case "setupvector": {
                this.setUpScheme();
                break;
            }
            case "barchart": {
                String labelName = ((ChartClickEvent)evt).getName();
                HashMap<String, Object> customParams = new HashMap<String, Object>(3);
                Object schemeId = this.getModel().getValue(SCHEME_ID);
                customParams.put(SCHEME_ID, schemeId);
                customParams.put(bar_chart_Label, labelName);
                PageUtils.showFormPage((IFormView)this.getView(), (String)"mobim_agereportdetail", customParams, null);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "chooseScheme": {
                this.chooseSchemeClosedCallBack(closedCallBackEvent);
                break;
            }
        }
    }

    private void chooseSchemeClosedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        DynamicObject scheme = SchemeOpHelper.getSingleScheme((Long)Long.valueOf(String.valueOf(returnData)));
        this.initData(scheme);
    }

    private void setUpScheme() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mobim_invbillagefilter");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        Object schemeId = this.getModel().getValue(SCHEME_ID);
        if (schemeId != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(schemeId))) {
            formShowParameter.setCustomParam(SCHEME_ID, (Object)Long.valueOf(String.valueOf(schemeId)));
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void chooseScheme() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("frequently_scheme_list");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHOOSE_SCHEME));
        Object schemeId = this.getModel().getValue(SCHEME_ID);
        if (schemeId != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(schemeId))) {
            formShowParameter.setCustomParam(SCHEME_ID, (Object)Long.valueOf(String.valueOf(schemeId)));
        }
        formShowParameter.setCustomParam("schemetype", (Object)this.getReportFormKey());
        formShowParameter.setCustomParam(FORM_KEY, (Object)"mobim_invbillagefilter");
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void buildBarChart(DynamicObject scheme) {
        Control barChartAp = this.getView().getControl(BAR_CHART);
        BarChart barChart = null;
        if (barChartAp instanceof BarChart) {
            barChart = (BarChart)barChartAp;
        }
        if (barChart == null) {
            return;
        }
        barChart.clearData();
        DynamicObject filterDyn = InvBillAgeReportHelper.getDynamicObjectByScheme(scheme);
        ReportQueryParam queryParam = InvBillAgeReportHelper.getReportQueryParam(filterDyn);
        DataSet dataSet = InvBillAgeReportHelper.query(queryParam);
        List<String> yLabelData = InvBillAgeReportHelper.getGroups(filterDyn);
        List<Integer> xLabelData = this.getXLabelData(dataSet, yLabelData);
        List<String> labelColorList = InvBillAgeReportHelper.getLabelColorList();
        this.buildYAxis(barChart, yLabelData);
        barChart.setMargin(Position.top, "5%");
        barChart.setMargin(Position.right, "10%");
        BarSeries series = barChart.createSeries("");
        int maxValue = 0;
        for (int i = 0; i < yLabelData.size(); ++i) {
            String label = yLabelData.get(i);
            Integer value = xLabelData.get(i);
            maxValue = Math.max(xLabelData.get(i), maxValue);
            String color = i >= 6 ? labelColorList.get(6) : labelColorList.get(i);
            series.addData(label, (Number)value, color);
        }
        series.setBarWidth("24");
        series.setPropValue("barGap", (Object)"0");
        series.setPropValue("barCategoryGap", (Object)"10%");
        this.buildXAxis(barChart, maxValue);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.right);
        label.setBorderRadius("10px");
        String msg = ResManager.loadKDString((String)"\u7269\u6599\u79cd\u7c7b", (String)"AppHomeV4Plugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
        label.setFormatter(msg + ":{c}");
        label.setColor("#666666");
        label.setFontSize("10");
        series.setLabel(label);
        this.getView().updateView(BAR_CHART);
    }

    private List<Integer> getXLabelData(DataSet dataSet, List<String> yLabelData) {
        int size = yLabelData.size();
        ArrayList<Integer> xData = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            int count = 0;
            if (dataSet != null && !dataSet.isEmpty()) {
                count = dataSet.copy().filter("baseqtyrang" + i + " > 0").count("material", true);
            }
            xData.add(count);
        }
        return xData;
    }

    private void buildYAxis(BarChart barChart, List<String> yLabelData) {
        Axis yAxis = barChart.createYAxis("", AxisType.category);
        yAxis.setCategorys(yLabelData.toArray(new String[0]));
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisShowMap);
        HashMap axisLabelMap = new HashMap(3);
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>(3);
        textStyleMap.put("fontSize", 14);
        textStyleMap.put("color", "#666666");
        axisLabelMap.put("textStyle", textStyleMap);
        yAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("axisLine", axisLine);
    }

    private void buildXAxis(BarChart barChart, int maxValue) {
        Axis xAxis = barChart.createXAxis("", AxisType.value);
        xAxis.setPropValue("minInterval", (Object)1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(3);
        lineStyleMap.put("type", "dashed");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>(3);
        splitLineMap.put("lineStyle", lineStyleMap);
        xAxis.setPropValue("splitLine", splitLineMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisShowMap);
        xAxis.setPropValue("axisTick", axisShowMap);
        xAxis.setPropValue("boundaryGap", (Object)true);
        double value = (double)maxValue + (double)maxValue * 0.25;
        BigDecimal maxBig = BigDecimal.valueOf(value);
        BigDecimal maxCeil = maxBig.setScale(0, 0);
        BigDecimal maxDown = maxCeil.setScale(-1, 0);
        BigDecimal maxUp = maxDown.setScale(-2, 0);
        int max = maxUp.intValue();
        xAxis.setPropValue("max", (Object)max);
    }

    public String getReportFormKey() {
        return "invBillAgeReport";
    }
}

