/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.report.invbillage;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.scmc.mobim.business.helper.InvBillAgeReportHelper;
import kd.scmc.mobim.common.utils.QuantityUtils;

public class MaterialReportDetailPlugin
extends AbstractMobBillPlugIn {
    private static final String PIE_CHART_AP = "piechartap";
    private static final String MATERIAL_ID = "materialId";
    private static final String ENTRY_BASE_QTY = "baseqty";
    private static final String SUM_BASE_QTY = "sumbaseqty";
    private static final String BASE_UNIT = "baseunit";
    private static final String MATERIAL = "material";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String UNIT_LABEL = "unitlabel";
    private static final String ENTRY_UINT = "entryuint";

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        BigDecimal qty2;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object materialId = formShowParameter.getCustomParam(MATERIAL_ID);
        Object unitId = formShowParameter.getCustomParam(BASE_UNIT);
        Object group = formShowParameter.getCustomParam("invagegroup");
        Object data = formShowParameter.getCustomParam("intervaldays");
        List groups = JSON.parseArray((String)String.valueOf(group), String.class);
        int size = groups.size();
        List<BigDecimal> dataList = new ArrayList(size);
        BigDecimal sumQty = new BigDecimal("0");
        if (data != null) {
            dataList = JSON.parseArray((String)String.valueOf(data), BigDecimal.class);
            for (BigDecimal qty2 : dataList) {
                sumQty = sumQty.add(qty2);
            }
        }
        IDataModel model = this.getModel();
        model.setValue(MATERIAL, materialId);
        model.setValue(BASE_UNIT, unitId);
        qty2 = sumQty.stripTrailingZeros();
        model.setValue(SUM_BASE_QTY, (Object)QuantityUtils.addSeparator(qty2));
        Object unit = model.getValue(BASE_UNIT);
        this.buildPieChart(groups, dataList);
        this.setUnit(unit);
        this.setEntryInfo(groups, dataList);
        this.getView().updateView();
    }

    private void buildPieChart(List<String> groups, List<BigDecimal> dataList) {
        Control pieChartAp = this.getView().getControl(PIE_CHART_AP);
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart == null) {
            return;
        }
        pieChart.clearData();
        pieChart.setShowLegend(false);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("triggerOn", (Object)"click");
        PieSeries series = pieChart.createSeries("");
        List<String> labelColorList = InvBillAgeReportHelper.getLabelColorList();
        for (int i = 0; i < groups.size(); ++i) {
            String label = groups.get(i);
            String color = i >= 6 ? labelColorList.get(6) : labelColorList.get(i);
            series.addData(label, (Number)dataList.get(i), color);
        }
        series.setRadius("50%", "70%");
        HashMap<String, Boolean> showMap = new HashMap<String, Boolean>(1);
        showMap.put("show", Boolean.TRUE);
        HashMap<String, HashMap<String, Boolean>> labelMap = new HashMap<String, HashMap<String, Boolean>>(1);
        labelMap.put("label", showMap);
        series.setPropValue("emphasis", labelMap);
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        label.setFormatter(ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\uff1a{b}\n\u5e93\u5b58\u6570\u91cf: {c}\n{d}%", (String)"MaterialReportDetailPlugin_buildPieChart_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        series.setLabel(label);
        pieChart.refresh();
        this.getView().updateView(PIE_CHART_AP);
    }

    private void setEntryInfo(List<String> groups, List<BigDecimal> dataList) {
        IDataModel model = this.getModel();
        int size = groups.size();
        model.deleteEntryData(ENTRY_ENTITY);
        model.batchCreateNewEntryRow(ENTRY_ENTITY, size);
        CardEntry grid = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        List<String> colorList = InvBillAgeReportHelper.getLabelColorList();
        for (int i = 0; i < size; ++i) {
            String name = groups.get(i);
            BigDecimal decimal = new BigDecimal("0");
            if (!dataList.isEmpty()) {
                decimal = dataList.get(i);
            }
            HashMap<String, String> proData = new HashMap<String, String>(2);
            String color = i >= 6 ? colorList.get(6) : colorList.get(i);
            proData.put("fc", color);
            proData.put("bc", color);
            HashMap<String, HashMap<String, String>> keyToProData = new HashMap<String, HashMap<String, String>>(16);
            keyToProData.put("colourlabel", proData);
            grid.setCustomProperties("colourlabel", i, keyToProData);
            model.setValue("invagegroup", (Object)name, i);
            BigDecimal qty = decimal.stripTrailingZeros();
            model.setValue(ENTRY_BASE_QTY, (Object)QuantityUtils.addSeparator(qty), i);
        }
    }

    private void setUnit(Object unit) {
        String unitName = "";
        if (unit != null) {
            unitName = ((DynamicObject)unit).getString("name");
        }
        kd.bos.form.control.Label unitLabel = (kd.bos.form.control.Label)this.getView().getControl(UNIT_LABEL);
        unitLabel.setText(unitName);
        kd.bos.form.control.Label entryUnitLabel = (kd.bos.form.control.Label)this.getView().getControl(ENTRY_UINT);
        entryUnitLabel.setText(unitName);
    }
}

