/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.common.design.hompage.region;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.mobpm.common.enums.ChangeStatusEnum;
import kd.scmc.mobpm.common.enums.EnableStatusEnum;
import kd.scmc.mobpm.common.utils.PurDateUtils;
import kd.scmc.mobpm.plugin.form.puranalysis.PurAnalysisQueryDataPlugin;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.design.homepage.region.HomePageBuildDefaultDataRegion;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.pojo.CardData;

public class MobpmNumberRegion
extends HomePageBuildDefaultDataRegion {
    private static final String[] BIZTYPE = new String[]{"110", "130"};
    private static final String MOBPM = "mobpm";
    private static final String CARD_VIEW = "2DUC=B5588VZ";

    public MobpmNumberRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setNumberDate();
        this.setNumberCard(this.getOrgId());
    }

    public void setNumberDate() {
        Map<String, Date> startAndEndDateOfTheCurrentMonth = PurDateUtils.getStartAndEndDateOfTheCurrentMonth();
        Date startDate = startAndEndDateOfTheCurrentMonth.get("startDate");
        Date endDate = startAndEndDateOfTheCurrentMonth.get("endDate");
        this.getView().getModel().setValue("numbercaredate_startdate", (Object)startDate);
        this.getView().getModel().setValue("numbercaredate_enddate", (Object)endDate);
    }

    public void setNumberCard(Long orgId) {
        Label purAmountLab = (Label)this.getView().getControl("labelap4");
        Label newSupplierNumLab = (Label)this.getView().getControl("labelap7");
        Label timelyReceiptRateLab = (Label)this.getView().getControl("labelap8");
        Date startDate = (Date)this.getView().getModel().getValue("numbercaredate_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("numbercaredate_enddate");
        boolean numberCardPermission = this.permissionNumberCard(orgId);
        if (numberCardPermission) {
            BigDecimal totalAmount = this.getTotalAmount(orgId, startDate, endDate);
            Integer newSupplierNum = this.getNewSupplierNum(orgId, startDate, endDate);
            BigDecimal timelyReceiptRate = this.getTimelyReceiptRate(orgId, startDate, endDate);
            purAmountLab.setText(totalAmount.stripTrailingZeros().toPlainString());
            newSupplierNumLab.setText(String.valueOf(newSupplierNum));
            timelyReceiptRateLab.setText(timelyReceiptRate.stripTrailingZeros().toPlainString());
            this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap", "labelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap2"});
        } else {
            purAmountLab.setText("***");
            newSupplierNumLab.setText("***");
            timelyReceiptRateLab.setText("***");
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap", "labelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap2"});
        }
    }

    private QFilter getExpireFilter(Long orgId, Date startDate, Date endDate) {
        QFilter expireFilter = new QFilter("org", "=", (Object)orgId);
        expireFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        expireFilter.and(new QFilter("changestatus", "!=", (Object)ChangeStatusEnum.CHANGING.getValue()));
        expireFilter.and(new QFilter("biztype.number", "in", (Object)BIZTYPE));
        expireFilter.and(new QFilter("billentry.deliverdate", ">=", (Object)startDate));
        expireFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)endDate));
        expireFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)TimeServiceHelper.today()));
        return expireFilter;
    }

    private QFilter getTodayFilter(Long orgId) {
        QFilter todayFilter = new QFilter("org", "=", (Object)orgId);
        todayFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        todayFilter.and(new QFilter("changestatus", "!=", (Object)ChangeStatusEnum.CHANGING.getValue()));
        todayFilter.and(new QFilter("biztype.number", "in", (Object)BIZTYPE));
        todayFilter.and(new QFilter("billentry.deliverdate", "=", (Object)PurDateUtils.getDate(TimeServiceHelper.today())));
        todayFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)TimeServiceHelper.today()));
        return todayFilter;
    }

    private BigDecimal getTimelyReceiptRate(Long orgId, Date startDate, Date endDate) {
        QFilter expireFilter = this.getExpireFilter(orgId, startDate, endDate);
        QFilter todayFilter = this.getTodayFilter(orgId);
        DataSet timelyReceiptRateData = PurAnalysisQueryDataPlugin.getTimelyReceiptRateData(((Object)((Object)this)).getClass().getName(), expireFilter, todayFilter, startDate, endDate);
        BigDecimal expireNum = BigDecimal.ZERO;
        BigDecimal onTimeNum = BigDecimal.ZERO;
        BigDecimal timelyReceiptRate = new BigDecimal("0.00");
        while (timelyReceiptRateData.hasNext()) {
            Row row = timelyReceiptRateData.next();
            expireNum = expireNum.add(row.getBigDecimal("expireordernum"));
            onTimeNum = onTimeNum.add(row.getBigDecimal("ontimenum"));
        }
        if (BigDecimal.ZERO.compareTo(expireNum) != 0) {
            timelyReceiptRate = onTimeNum.multiply(new BigDecimal("100")).divide(expireNum, 2, RoundingMode.HALF_UP);
        }
        return timelyReceiptRate;
    }

    private Integer getNewSupplierNum(Long orgId, Date startDate, Date endDate) {
        endDate = PurDateUtils.getStartOrEndDate(endDate, true);
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgId);
        qFilter.and(new QFilter("createorg", "=", (Object)orgId));
        qFilter.and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)endDate));
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_supplier", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null).count("id", false);
    }

    private BigDecimal getTotalAmount(Long orgId, Date startDate, Date endDate) {
        QFilter qFilter = this.getFilter(orgId, startDate, endDate);
        DataSet totalAmountData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"billentry.curamountandtax", (QFilter[])new QFilter[]{qFilter}, null).groupBy().sum("billentry.curamountandtax").finish();
        BigDecimal totalAmount = new BigDecimal("0.00");
        if (totalAmountData.hasNext()) {
            Row row = totalAmountData.next();
            totalAmount = row.getBigDecimal("billentry.curamountandtax");
        }
        return totalAmount;
    }

    private QFilter getFilter(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("billentry.curamountandtax", "<>", (Object)BigDecimal.ZERO));
        return qFilter;
    }

    private boolean permissionNumberCard(Long orgId) {
        if (orgId != null) {
            return PermissionHelper.checkPermission((Long)orgId, (String)MOBPM, (String)"mobpm_homepage_v4", (String)CARD_VIEW);
        }
        return false;
    }
}

