/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.common.design.hompage.region;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.threads.ThreadPools;
import kd.scmc.mobpm.common.enums.ABCInfoEnum;
import kd.scmc.mobpm.plugin.form.puranalysis.PurAnalysisQueryDataPlugin;
import kd.scmc.mobpm.pojo.ABCAnalysisInfo;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionSingleRegion;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.pojo.CardData;

public class MobpmSupplierABCRegion
extends CheckPermissionSingleRegion {
    private static final String PM = "pm";

    public MobpmSupplierABCRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public MobpmSupplierABCRegion(IFormView view) {
        super(null, null, null, view);
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setSupplierABCPieChart(setting, this.getOrgId());
    }

    public void setSupplierABCPieChart(CardData setting, Long orgId) {
        if (orgId == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"afterbusinessflex"});
            return;
        }
        Boolean permResult = this.singleCheckPermission();
        if (!this.isPresent(setting) || Boolean.FALSE.equals(permResult)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"afterbusinessflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"afterbusinessflex"});
        this.getView().updateView("afterbusinessflex");
        ThreadPools.executeOnce((String)this.getView().getPageId(), () -> {
            List<ABCAnalysisInfo> abcAnalysisInfos = this.getSupplierABCAnalysisData(orgId);
            this.getView().getPageCache().putBigObject("pm_supplier_abc", SerializationUtils.toJsonString(abcAnalysisInfos));
        });
        this.getView().getPageCache().put("counter", String.valueOf(1));
        this.getView().getPageCache().put("latencyTime", String.valueOf(1000));
        this.getView().addClientCallBack("chart", Integer.valueOf(1000));
    }

    private List<ABCAnalysisInfo> getSupplierABCAnalysisData(Long orgId) {
        DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)"mobpm_supplierabcanalysis");
        if (scheme == null) {
            Date startDate = DateUtils.getThisWeekStartDate();
            Date endDate = DateUtils.getThisWeekEndDate();
            QFilter qFilter = this.getFilter(orgId, startDate, endDate);
            Map<String, BigDecimal> abcRate = this.getABCRate();
            return PurAnalysisQueryDataPlugin.querySupplierABCAnalysisData(((Object)((Object)this)).getClass().getName(), qFilter, abcRate);
        }
        String filterContent = scheme.getString("content_tag");
        DynamicObject newFilter = BusinessDataServiceHelper.newDynamicObject((String)"mobpm_supabcanalfilter");
        Object[] entityArr = DynamicObjectSerializeUtil.deserialize((String)filterContent, (DynamicObjectType)newFilter.getDynamicObjectType());
        DynamicObject filterDyn = (DynamicObject)entityArr[0];
        DynamicObject org = filterDyn.getDynamicObject("org");
        Date startDate = filterDyn.getDate("daterange_startdate");
        Date endDate = filterDyn.getDate("daterange_enddate");
        QFilter qFilter = this.getFilter(org.getPkValue(), startDate, endDate);
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(3);
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            BigDecimal rate = filterDyn.getBigDecimal(info.getSign());
            rateMap.put(info.getSign(), rate);
        }
        return PurAnalysisQueryDataPlugin.querySupplierABCAnalysisData(((Object)((Object)this)).getClass().getName(), qFilter, rateMap);
    }

    private QFilter getFilter(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("billentry.curamountandtax", "<>", (Object)BigDecimal.ZERO));
        return qFilter;
    }

    private Map<String, BigDecimal> getABCRate() {
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(3);
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            rateMap.put(info.getSign(), info.getDefaultValue());
        }
        return rateMap;
    }

    public Boolean singleCheckPermission() {
        return PermissionHelper.checkPermission((Long)this.getOrgId(), (String)PM, (String)"pm_supplier_abc", (String)"47150e89000000ac");
    }
}

