/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.common.design.hompage.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.common.design.homepage.CheckPermissionCalculator;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionMultipleRegion;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.pojo.CardData;
import kd.scmc.msmob.pojo.ControlPermInfo;
import kd.scmc.msmob.pojo.PermItemInfo;

public class MobpmToDoBusinessRegion
extends CheckPermissionMultipleRegion {
    private static final String PM = "pm";

    public MobpmToDoBusinessRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public Map<String, Boolean> checkPermission() {
        return CheckPermissionCalculator.checkPermission((Long)this.getOrgId(), (String)PM, this.getControlPermItems());
    }

    public List<ControlPermInfo> getControlPermItems() {
        return Arrays.asList(new ControlPermInfo("submitpurapply", "02", Collections.singletonList(new PermItemInfo("pm_purapplybill", Collections.singletonList("47150e89000000ac")))), new ControlPermInfo("submitpurorder", "02", Collections.singletonList(new PermItemInfo("pm_purorderbill", Collections.singletonList("47150e89000000ac")))), new ControlPermInfo("submitpurrefundapply", "02", Collections.singletonList(new PermItemInfo("pm_purrefundapplybill", Collections.singletonList("47150e89000000ac")))));
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setToDoBusinessCard(this.getOrgId());
    }

    public void setToDoBusinessCard(Long orgId) {
        Date startDate = (Date)this.getView().getModel().getValue("todobusiness_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("todobusiness_enddate");
        Label purApplyLab = (Label)this.getView().getControl("submitpurapplyqty");
        Label purOrderLab = (Label)this.getView().getControl("submitpurorderqty");
        Label purRefApplyLab = (Label)this.getView().getControl("submitpurrefundapplyqty");
        List<String> pcFormKeys = MobpmToDoBusinessRegion.getToDoBusinessBillKeys();
        Iterator<String> iterator = pcFormKeys.iterator();
        while (iterator.hasNext()) {
            String pcFormKey;
            switch (pcFormKey = iterator.next()) {
                case "pm_purapplybill": {
                    this.setLabelText(orgId, "pm_purapplybill", startDate, endDate, purApplyLab);
                    break;
                }
                case "pm_purorderbill": {
                    this.setLabelText(orgId, "pm_purorderbill", startDate, endDate, purOrderLab);
                    break;
                }
                case "pm_purrefundapplybill": {
                    this.setLabelText(orgId, "pm_purrefundapplybill", startDate, endDate, purRefApplyLab);
                    break;
                }
            }
        }
    }

    private Integer getBillCount(Long orgId, String entityName, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        DataSet billCount = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"id,billno,createtime", (QFilter[])new QFilter[]{qFilter}, null).distinct();
        return billCount.count("id", false);
    }

    private void setLabelText(Long orgId, String entityName, Date startDate, Date endDate, Label label) {
        int billCount = this.getBillCount(orgId, entityName, startDate, endDate);
        label.setText(String.valueOf(billCount));
    }

    private static List<String> getToDoBusinessBillKeys() {
        ArrayList<String> pcFormKeys = new ArrayList<String>(10);
        pcFormKeys.add("pm_purapplybill");
        pcFormKeys.add("pm_purorderbill");
        pcFormKeys.add("pm_purrefundapplybill");
        return pcFormKeys;
    }
}

