/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.RefreshResultType;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.mvc.form.MobileFormView;
import kd.scmc.mobpm.common.design.hompage.handle.MobpmHomePageBuilder;
import kd.scmc.mobpm.common.enums.ABCInfoEnum;
import kd.scmc.mobpm.common.utils.PurDateUtils;
import kd.scmc.mobpm.pojo.ABCAnalysisInfo;
import kd.scmc.msmob.common.design.homepage.handle.HomePageBuilder;
import kd.scmc.msmob.plugin.tpl.basetpl.home.AbstractMobAppHomeBaseTplPlugin;

public class AppHomePageV4Plugin
extends AbstractMobAppHomeBaseTplPlugin {
    public static String[] button = new String[]{"mobpm_purapplynew", "mobpm_purapplylist", "mobpm_purorderlist", "mobpm_purrefundapplylist", "mobpm_reqapplybilllist", "mobpm_supplierabcanalysis", "mobpm_materialabcanalysis", "mobpm_timelyreceiptrate"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(button);
        this.addClickListeners(new String[]{"submitpurapply", "submitpurorder", "submitpurrefundapply", "analysisdetail"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        switch (key) {
            case "mobpm_purapplynew": {
                this.goUrl(orgId, formShowParameter, "mobpm_purapplybilledit");
                break;
            }
            case "mobpm_purapplylist": {
                this.goUrl(orgId, formShowParameter, "mobpm_purapplylist");
                break;
            }
            case "mobpm_purorderlist": {
                this.goUrl(orgId, formShowParameter, "mobpm_purorderlist");
                break;
            }
            case "mobpm_purrefundapplylist": {
                this.goUrl(orgId, formShowParameter, "mobpm_purrefundapplylist");
                break;
            }
            case "mobpm_reqapplybilllist": {
                this.goUrl(orgId, formShowParameter, "mobpm_reqapplybilllist");
                break;
            }
            case "mobpm_supplierabcanalysis": 
            case "analysisdetail": {
                this.goUrl(orgId, formShowParameter, "mobpm_supplierabcanalysis");
                break;
            }
            case "mobpm_materialabcanalysis": {
                this.goUrl(orgId, formShowParameter, "mobpm_materialabcanalysis");
                break;
            }
            case "mobpm_timelyreceiptrate": {
                this.goUrl(orgId, formShowParameter, "mobpm_timelyreceiptrate");
                break;
            }
            case "submitpurapply": {
                formShowParameter.setCustomParam("todoDate", (Object)"todoDate");
                this.goUrl(orgId, formShowParameter, "mobpm_purapplylist");
                break;
            }
            case "submitpurorder": {
                formShowParameter.setCustomParam("todoDate", (Object)"todoDate");
                this.goUrl(orgId, formShowParameter, "mobpm_purorderlist");
                break;
            }
            case "submitpurrefundapply": {
                formShowParameter.setCustomParam("todoDate", (Object)"todoDate");
                this.goUrl(orgId, formShowParameter, "mobpm_purrefundapplylist");
                break;
            }
        }
    }

    public void refreshData() {
        super.refreshData();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            this.buildHomePage(orgId);
        }
        ((MobileFormView)this.getView()).setRefreshResult(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"AppHomePageV4Plugin_refreshData_0", (String)"scmc-mobpm-form", (Object[])new Object[0]), Integer.valueOf(3000), RefreshResultType.Success);
    }

    public void initEntityPermItem() {
    }

    public void setToDoBusinessCard(Long orgId) {
    }

    public void setAgEndBusinessDate() {
        Map<String, Date> startAndEndDateOfThreeMonth = PurDateUtils.getStartAndEndDateOfThreeMonth();
        this.getModel().setValue("todobusiness_startdate", (Object)startAndEndDateOfThreeMonth.get("startDate"));
        this.getModel().setValue("todobusiness_enddate", (Object)startAndEndDateOfThreeMonth.get("endDate"));
    }

    public Map<String, Boolean> checkPermission(Long org) {
        return new HashMap<String, Boolean>(0);
    }

    public String getShowBillKey() {
        return null;
    }

    private void goUrl(Long orgId, MobileFormShowParameter formShowParameter, String purBill) {
        formShowParameter.setFormId(purBill);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("org", (Object)orgId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public Object getChartData() {
        return this.getPageCache().getBigObject("pm_supplier_abc");
    }

    public void buildHomePageChart() {
        String abcAnalysisInfoStr = this.getPageCache().getBigObject("pm_supplier_abc");
        List abcAnalysisInfos = SerializationUtils.fromJsonStringToList((String)abcAnalysisInfoStr, ABCAnalysisInfo.class);
        this.setABCCount(abcAnalysisInfos);
        this.buildPieChart(abcAnalysisInfos);
        this.getPageCache().removeBigObject("pm_supplier_abc");
    }

    private void setABCCount(List<ABCAnalysisInfo> abcAnalysisInfos) {
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            long count = abcAnalysisInfos.stream().filter(sup -> Objects.equals(sup.getGroup(), info.getValue())).count();
            this.getModel().setValue(info.getCountSign(), (Object)count);
        }
    }

    private void buildPieChart(List<ABCAnalysisInfo> abcAnalysisInfos) {
        Control pieChartAp = this.getView().getControl("piechartap");
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart == null) {
            return;
        }
        pieChart.clearData();
        PieSeries pieSeries = pieChart.createSeries("");
        if (abcAnalysisInfos.isEmpty()) {
            for (ABCInfoEnum info : ABCInfoEnum.values()) {
                pieSeries.addData(info.getName(), (Number)BigDecimal.ZERO, info.getColor());
            }
        } else {
            for (ABCInfoEnum info : ABCInfoEnum.values()) {
                Optional<BigDecimal> rate = abcAnalysisInfos.stream().filter(sup -> Objects.equals(sup.getGroup(), info.getValue())).map(ABCAnalysisInfo::getPurProportion).reduce(BigDecimal::add);
                rate.ifPresent(bigDecimal -> pieSeries.addData(info.getName(), (Number)bigDecimal, info.getColor()));
            }
        }
        pieSeries.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setFormatter("{b}:{d}%");
        label.setColor("#666666");
        pieSeries.setLabel(label);
        this.getView().updateView("piechartap");
    }

    protected HomePageBuilder getHomePageBuilder() {
        return new MobpmHomePageBuilder(this.getView());
    }
}

