/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.mobpm.common.utils.FormUtils;

public class AppHomePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_NUM = "entityNum";
    private static final String PERM_ITEM_ID = "permItemId";
    private Map<String, Map<String, String>> permItems = new HashMap<String, Map<String, String>>(12);
    private String[] button = new String[]{"mobpm_purapplylist", "mobpm_purorderlist", "mobpm_purrefundapplylist", "mobpm_reqapplybilllist", "mobpm_supplierabcanalysis", "mobpm_materialabcanalysis", "mobpm_timelyreceiptrate"};

    public void initialize() {
        super.initialize();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setOrgFunc("15");
        this.setCheckPerm();
    }

    private void setCheckPerm() {
        HashMap<String, String> orderPerms = new HashMap<String, String>(2);
        orderPerms.put(ENTITY_NUM, "pm_purorderbill");
        orderPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_purorderlist", orderPerms);
        HashMap<String, String> applyPerms = new HashMap<String, String>(2);
        applyPerms.put(ENTITY_NUM, "pm_purapplybill");
        applyPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_purapplylist", applyPerms);
        HashMap<String, String> refundApplyPerms = new HashMap<String, String>(2);
        refundApplyPerms.put(ENTITY_NUM, "pm_purrefundapplybill");
        refundApplyPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_purrefundapplylist", refundApplyPerms);
        HashMap<String, String> reqApplyPerms = new HashMap<String, String>(2);
        reqApplyPerms.put(ENTITY_NUM, "pm_requirapplybill");
        reqApplyPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_reqapplybilllist", reqApplyPerms);
        HashMap<String, String> supplierABCPerms = new HashMap<String, String>(2);
        supplierABCPerms.put(ENTITY_NUM, "mobpm_supplierabcanalysis");
        supplierABCPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_supplierabcanalysis", supplierABCPerms);
        HashMap<String, String> materialABCPerms = new HashMap<String, String>(2);
        materialABCPerms.put(ENTITY_NUM, "mobpm_materialabcanalysis");
        materialABCPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_materialabcanalysis", materialABCPerms);
        HashMap<String, String> timelyReceiptPerms = new HashMap<String, String>(2);
        timelyReceiptPerms.put(ENTITY_NUM, "mobpm_timelyreceiptrate");
        timelyReceiptPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mobpm_timelyreceiptrate", timelyReceiptPerms);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, "org");
        this.addClickListeners(this.button);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "org": {
                this.beforeOrgSelect(e);
                break;
            }
        }
    }

    private void beforeOrgSelect(BeforeF7SelectEvent e) {
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        HasPermOrgResult hasPermOrgy = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (!hasPermOrgy.hasAllOrgPerm()) {
            List orgIdList = hasPermOrgy.getHasPermOrgs();
            FormShowParameter formShowParameter = e.getFormShowParameter();
            formShowParameter.setCustomParam("range", (Object)orgIdList);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.checkPermission();
    }

    private void setOrg() {
        IDataModel model = this.getModel();
        RequestContext requestContext = RequestContext.get();
        Object org = this.getModel().getValue("org");
        long curOrgId = org == null ? requestContext.getOrgId() : ((Long)((DynamicObject)org).getPkValue()).longValue();
        long userId = Long.parseLong(requestContext.getUserId());
        List<Long> permOrgIdList = AppHomePlugin.getPermInvOrgIds(userId);
        Long invOrgId = curOrgId;
        if (permOrgIdList.isEmpty()) {
            invOrgId = null;
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\uff01", (String)"AppHomePlugin_0", (String)"scmc-mobpm-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
        if (!permOrgIdList.contains(curOrgId)) {
            invOrgId = permOrgIdList.get(0);
        }
        model.setValue("org", (Object)invOrgId);
    }

    private static List<Long> getPermInvOrgIds(long userId) {
        HasPermOrgResult orgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        List invPermOrgs = new ArrayList(32);
        if (orgs.hasAllOrgPerm()) {
            invPermOrgs = OrgUnitServiceHelper.getAllOrg((String)"15");
        } else {
            List hasPermOrgs = orgs.getHasPermOrgs();
            if (hasPermOrgs != null && hasPermOrgs.size() > 0) {
                invPermOrgs = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgs, (String)"15");
            }
        }
        return invPermOrgs;
    }

    private void checkPermission() {
        this.setOrg();
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        Object org = this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(12);
            for (Map.Entry<String, Map<String, String>> perms : this.permItems.entrySet()) {
                Map<String, String> perm = perms.getValue();
                String permKey = perms.getKey();
                int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"15", (String)"pm", (String)perm.get(ENTITY_NUM), (String)perm.get(PERM_ITEM_ID));
                permMap.put(permKey, hasPermResult == 1);
            }
            this.handleMenu(permMap);
        }
    }

    private void handleMenu(Map<String, Boolean> permMap) {
        permMap.forEach((key, value) -> this.getView().setVisible(value, new String[]{key}));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u7ec7\uff01", (String)"AppHomePluginClick_0", (String)"scmc-mobpm-form", (Object[])new Object[0]));
            return;
        }
        Long orgId = (Long)org.getPkValue();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        switch (key) {
            case "mobpm_purapplylist": {
                this.goUrl(orgId, formShowParameter, "mobpm_purapplylist");
                break;
            }
            case "mobpm_purorderlist": {
                this.goUrl(orgId, formShowParameter, "mobpm_purorderlist");
                break;
            }
            case "mobpm_purrefundapplylist": {
                this.goUrl(orgId, formShowParameter, "mobpm_purrefundapplylist");
                break;
            }
            case "mobpm_reqapplybilllist": {
                this.goUrl(orgId, formShowParameter, "mobpm_reqapplybilllist");
                break;
            }
            case "mobpm_supplierabcanalysis": {
                this.goUrl(orgId, formShowParameter, "mobpm_supplierabcanalysis");
                break;
            }
            case "mobpm_materialabcanalysis": {
                this.goUrl(orgId, formShowParameter, "mobpm_materialabcanalysis");
                break;
            }
            case "mobpm_timelyreceiptrate": {
                this.goUrl(orgId, formShowParameter, "mobpm_timelyreceiptrate");
                break;
            }
        }
    }

    private void goUrl(Long orgId, MobileFormShowParameter formShowParameter, String purBill) {
        formShowParameter.setFormId(purBill);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("org", (Object)orgId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("org".equals(key)) {
            this.checkPermission();
        }
    }
}

