/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.apply;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.mobpm.business.PurChaseChangedHandler;
import kd.scmc.mobpm.business.PurChaseDeleteHandler;
import kd.scmc.mobpm.plugin.form.apply.IPurApplyPagePlugin;
import kd.scmc.mobpm.plugin.form.apply.handler.PurChaseAddRowHandler;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;

public class PurApplyBillEditPlugin
extends MobPushTargetBillInfoPlugin
implements IPurApplyPagePlugin,
IMobBillEditable,
BeforeF7SelectListener {
    public PurApplyBillEditPlugin() {
        this.registerPropertyChangedHandler(new PurChaseChangedHandler());
        this.registerEntryRowDeletedHandler(new PurChaseDeleteHandler());
        this.registerEntryRowAddedHandler(new PurChaseAddRowHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])new String[]{"biztype"});
    }

    public String getEntryFormKey() {
        return this.getEntryEditFormKey(this.getEntryEntity());
    }

    public void click(EventObject e) {
        this.editabilityPlugin.click(e);
    }

    protected void initDataOfNewPcEntity(DynamicObject newPcEntity) {
        IDataModel model = this.getModel();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("org");
        model.setValue("org", orgId);
        newPcEntity.set("org", this.getModel().getValue("org"));
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurService4Mobile", (String)"createNewData4Mob", (Object[])new Object[]{newPcEntity});
    }

    protected void newDefaultEntryRow(DynamicObject newPcEntity) {
        super.newDefaultEntryRow(newPcEntity);
        String pcEntryKey = DataSourceConfigHelper.getPcEntryKey((DataSourceConfig)this.getDataSourceConfig(), (String)this.getEntryEntity());
        DynamicObjectCollection pcEntryCollection = newPcEntity.getDynamicObjectCollection(pcEntryKey);
        DynamicObject newPcEntryRow = pcEntryCollection.addNew();
        int currentEntryRowCount = pcEntryCollection.getRowCount();
        long generatedNewEntryId = DB.genLongId((String)pcEntryKey);
        newPcEntryRow.set("id", (Object)generatedNewEntryId);
        if (newPcEntryRow.containsProperty("seq")) {
            newPcEntryRow.set("seq", (Object)currentEntryRowCount);
        }
        ArrayList<Long> entryIdList = new ArrayList<Long>(12);
        entryIdList.add(generatedNewEntryId);
        newPcEntity = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurService4Mobile", (String)"addRow4Mob", (Object[])new Object[]{newPcEntity, pcEntryKey, entryIdList});
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getPcEntityKey());
        this.updateEntityCache(mainEntityType, newPcEntity);
    }

    private void updateEntityCache(MainEntityType dataEntityType, DynamicObject pcEntity) {
        if (pcEntity == null || dataEntityType == null) {
            return;
        }
        DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)this, (DynamicObject)pcEntity, (boolean)true);
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        DynamicObject billType = pcEntityFromCache.getDynamicObject("billtype");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getPcEntityKey();
        switch (fieldKey) {
            case "biztype": {
                Long billTypeId = billType == null ? null : (Long)billType.getPkValue();
                List bizTypeIds = BizTypeHelper.getAllBizTypes((String)formId, (Long)billTypeId, (String)"pm_billtypeparameter");
                if (bizTypeIds == null) break;
                QFilter q1 = new QFilter("id", "in", (Object)bizTypeIds);
                showParameter.getListFilterParameter().getQFilters().add(q1);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                if (!operationResult.isSuccess()) break;
                this.setBillNo(operationResult);
                Boolean isModify = this.checkModifyPermission();
                if (!Boolean.TRUE.equals(isModify)) break;
                StringBuilder errMsg = new StringBuilder();
                Object pkId = operationResult.getSuccessPkIds().get(0);
                MutexHelper.require((IFormView)this.getView(), (String)this.getPcEntityKey(), pkId, (String)"modify", (boolean)Boolean.TRUE, (StringBuilder)errMsg);
                break;
            }
            case "submit": {
                this.updateModelValue();
                break;
            }
        }
        super.afterDoOperation(args);
    }

    private void updateModelValue() {
        DynamicObject pcEntityCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        this.curData = new DynamicObject[]{pcEntityCache};
        this.setModelValue();
    }

    private void setBillNo(OperationResult operationResult) {
        if ("".equals(this.getModel().getValue("billno"))) {
            String pcId = operationResult.getSuccessPkIds().get(0).toString();
            String billNo = (String)operationResult.getBillNos().get(pcId);
            this.getModel().setValue("billno", (Object)billNo);
        }
    }
}

