/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.apply;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.mobpm.business.MaterialHelper;
import kd.scmc.mobpm.business.PurChaseChangedHandler;
import kd.scmc.mobpm.plugin.form.apply.IPurApplyPagePlugin;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;

public class PurApplyBillEntryEditPlugin
extends EntryEditTplPlugin
implements IPurApplyPagePlugin,
BeforeF7SelectListener {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "currencyfield", "amountandtax", "priceandtax", "applyqty", "qty", "unit", "baseqty", "baseunit", "taxamount", "amount", "reqdate", "billid", "pcentitykey", "mobentryid", "taxrateid", "org", "istax"};

    public PurApplyBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new PurChaseChangedHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])new String[]{"material", "taxrateid"});
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        this.setModelNumVisible(material);
        this.setPriceEditable();
        this.setTaxTipNotification();
    }

    private void setPriceEditable() {
        boolean isTax = (Boolean)this.getModel().getValue("istax");
        this.getView().setEnable(Boolean.valueOf(isTax), new String[]{"priceandtax"});
    }

    private void setTaxTipNotification() {
        boolean tax = (Boolean)this.getModel().getValue("istax");
        if (!Boolean.TRUE.equals(tax)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u542b\u7a0e\uff0c\u65e0\u6cd5\u4fee\u6539\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurApplyBillEntryEditPlugin_1", (String)"scmc-mobpm-form", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IPageCache pageCache = this.getPageCache();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = (Long)org.getPkValue();
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        int rowIndex = Integer.parseInt(pageCache.get("row"));
        DynamicObject currentEntry = (DynamicObject)pcEntityFromCache.getDynamicObjectCollection(this.getPcEntryName()).get(rowIndex);
        DynamicObject bizType = pcEntityFromCache.getDynamicObject("biztype");
        DynamicObject billType = pcEntityFromCache.getDynamicObject("billtype");
        Long billTypeId = billType == null ? null : (Long)billType.getPkValue();
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "material": {
                DynamicObject lineType = currentEntry.getDynamicObject("lineType");
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u884c\u7c7b\u578b\u3002", (String)"PurApplyBillEntryEditPlugin_2", (String)"scmc-mobpm-form", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<QFilter> materialFilter = MaterialHelper.getQFilterByLineType(billTypeId, bizType == null ? null : (Long)bizType.getPkValue(), (Long)lineType.getPkValue(), this.getPcEntityKey(), true);
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)orgId);
                if (materialFilter != null) {
                    materialFilter.add(orgFilter);
                    showParameter.getListFilterParameter().getQFilters().addAll(materialFilter);
                }
                showParameter.getListFilterParameter().setOrderBy(BillSortType.DESC.name());
                break;
            }
            case "taxrateid": {
                Date bizTime = (Date)pcEntityFromCache.get("biztime");
                QFilter activeFilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expFilter = new QFilter("expdate", ">", (Object)bizTime);
                expFilter = QFilter.isNull((String)"expdate").or(expFilter);
                QFilter qFilter = expFilter.and(activeFilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    protected void goPreviousOrGoNext(String key) {
        super.goPreviousOrGoNext(key);
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        this.setModelNumVisible(material);
        this.setPriceEditable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            if (newValue == null) {
                return;
            }
            if (!"material".equals(fieldKey)) continue;
            DynamicObject material = (DynamicObject)newValue;
            this.setModelNumVisible(material);
        }
    }

    private void setModelNumVisible(DynamicObject material) {
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)material.getString("masterid.modelnum"));
        this.getView().setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
    }
}

