/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.homeforunittest;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.mobpm.common.utils.FormUtils;

public class UnittestHomePagePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_NUM = "entityNum";
    private static final String APPLY_BILL = "mobpm_pmapplybill";
    private static final String ORDER_BILL = "mobpm_pmorderbill";
    private static final String PUR_REFUND_APPLY_BILL = "mobpm_purrefundapplybill";
    private final String[] button = new String[]{"mobpm_pmapplybill", "mobpm_pmorderbill", "mobpm_purrefundapplybill"};

    public void initialize() {
        super.initialize();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setOrgFunc("15");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, "org");
        this.addClickListeners(this.button);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("org".equals(fieldKey)) {
            this.beforeOrgSelect();
        }
    }

    private void beforeOrgSelect() {
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        PermissionServiceHelper.getUserHasPermOrgs((long)currUserId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = (Long)org.getPkValue();
        MobileListShowParameter listShowParameter = new MobileListShowParameter();
        switch (key) {
            case "mobpm_pmapplybill": {
                this.goUrl(orgId, listShowParameter, APPLY_BILL);
                break;
            }
            case "mobpm_pmorderbill": {
                this.goUrl(orgId, listShowParameter, ORDER_BILL);
                break;
            }
            case "mobpm_purrefundapplybill": {
                this.goUrl(orgId, listShowParameter, PUR_REFUND_APPLY_BILL);
                break;
            }
        }
    }

    private void goUrl(Long orgId, MobileListShowParameter listShowParameter, String purBill) {
        listShowParameter.setBillFormId(purBill);
        listShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        listShowParameter.setCustomParam("org", (Object)orgId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

