/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.puranalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobpm.common.utils.PurDateUtils;
import kd.scmc.mobpm.pojo.ABCAnalysisInfo;

public abstract class ABCAnalysisDetailPlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap5", "mobilesearchap", "vectorap"});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("flexpanelap5".equals(key) || "vectorap".equals(key)) {
            this.sortEntryData();
        }
    }

    public void focus() {
        this.getModel().deleteEntryData("entryentity");
        this.searchABCEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getModel().deleteEntryData("entryentity");
        this.searchABCEntry();
    }

    public abstract List<ABCAnalysisInfo> queryData(QFilter var1, Map<String, BigDecimal> var2);

    private void initData() {
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(3);
        rateMap.put("rate_a", (BigDecimal)customParams.get("rate_a"));
        rateMap.put("rate_b", (BigDecimal)customParams.get("rate_b"));
        rateMap.put("rate_c", (BigDecimal)customParams.get("rate_c"));
        Date startDate = PurDateUtils.getDateFromString((String)customParams.get("startdate"));
        Date endDate = PurDateUtils.getDateFromString((String)customParams.get("enddate"));
        if (startDate == null || endDate == null) {
            return;
        }
        Object orgId = customParams.get("org");
        QFilter qFilter = this.buildFilter(orgId, startDate, endDate);
        List<ABCAnalysisInfo> abcAnalysisInfos = this.queryData(qFilter, rateMap);
        if (!abcAnalysisInfos.isEmpty()) {
            this.setDataToEntry(abcAnalysisInfos);
            this.getPageCache().put("showEntryList", JsonUtil.encodeToString(abcAnalysisInfos));
        } else {
            this.getPageCache().put("showEntryList", "empty");
        }
    }

    private void setDataToEntry(List<ABCAnalysisInfo> abcAnalysisInfos) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", abcAnalysisInfos.size());
        for (int index = 0; index < abcAnalysisInfos.size(); ++index) {
            ABCAnalysisInfo abcAnalysisInfo = abcAnalysisInfos.get(index);
            model.setValue("basedata", (Object)abcAnalysisInfo.getBaseData(), index);
            model.setValue("rank", (Object)abcAnalysisInfo.getGroup(), index);
            model.setValue("rate", (Object)abcAnalysisInfo.getPurProportion(), index);
            model.setValue("amount", (Object)abcAnalysisInfo.getAmount(), index);
            model.setValue("currency", (Object)abcAnalysisInfo.getCurrency(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void sortEntryData() {
        String tempEntryColl = this.getPageCache().get("tempEntryList");
        List entryRow = (List)JsonUtil.decodeFromString((String)tempEntryColl, List.class);
        if (entryRow == null || entryRow.isEmpty()) {
            String abcAnalysisEntryStr = this.getPageCache().get("showEntryList");
            if (abcAnalysisEntryStr.equals("empty")) {
                return;
            }
            entryRow = (List)JsonUtil.decodeFromString((String)abcAnalysisEntryStr, List.class);
        }
        ArrayList<ABCAnalysisInfo> abcAnalysisInfos = new ArrayList<ABCAnalysisInfo>(entryRow.size());
        for (JSONObject jsonObject : entryRow) {
            ABCAnalysisInfo entry = (ABCAnalysisInfo)JSON.toJavaObject((JSON)jsonObject, ABCAnalysisInfo.class);
            abcAnalysisInfos.add(entry);
        }
        String direct = this.getPageCache().get("sortDirection");
        if ("up".equals(direct)) {
            this.getPageCache().put("sortDirection", "down");
            abcAnalysisInfos.sort(Comparator.comparing(ABCAnalysisInfo::getAmount).reversed());
        } else {
            this.getPageCache().put("sortDirection", "up");
            abcAnalysisInfos.sort(Comparator.comparing(ABCAnalysisInfo::getAmount));
        }
        this.sortAndSearchSetData(abcAnalysisInfos);
    }

    private void sortAndSearchSetData(List<ABCAnalysisInfo> abcAnalysisInfos) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (int index = 0; index < abcAnalysisInfos.size(); ++index) {
            ABCAnalysisInfo abcAnalysisInfo = abcAnalysisInfos.get(index);
            model.setValue("basedata", (Object)abcAnalysisInfo.getBaseData(), index);
            model.setValue("rank", (Object)abcAnalysisInfo.getGroup(), index);
            model.setValue("rate", (Object)abcAnalysisInfo.getPurProportion(), index);
            model.setValue("amount", (Object)abcAnalysisInfo.getAmount(), index);
            model.setValue("currency", (Object)abcAnalysisInfo.getCurrency(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void searchABCEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        String entryStr = this.getPageCache().get("showEntryList");
        if (entryStr == null || entryStr.equals("empty")) {
            return;
        }
        List entryList = (List)JsonUtil.decodeFromString((String)entryStr, List.class);
        ArrayList<ABCAnalysisInfo> showList = new ArrayList<ABCAnalysisInfo>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            ABCAnalysisInfo entry = (ABCAnalysisInfo)JSON.toJavaObject((JSON)jsonObject, ABCAnalysisInfo.class);
            if (!entry.getBaseDataName().contains(search.getText())) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        if (!showList.isEmpty()) {
            this.setDataToEntry(showList);
        }
        int showCount = showList.size();
        for (i = 0; i < showList.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{"cardentryflexpanelap4"});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"cardentryflexpanelap4"});
        }
        this.getPageCache().put("tempEntryList", JsonUtil.encodeToString(showList));
    }

    protected QFilter buildFilter(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("billentry.curamountandtax", "<>", (Object)new BigDecimal(0)));
        return qFilter;
    }
}

