/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.puranalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.mobpm.common.enums.ABCInfoEnum;
import kd.scmc.mobpm.pojo.ABCAnalysisInfo;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ABCAnalysisTplPlugin
extends AbstractMobFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"selectscheme", "filtercondition", "analysisdetail", "vectorap1", "vectorap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initNewFilterAndData();
    }

    protected void initNewFilterAndData() {
        DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)this.getFormKey());
        if (scheme == null) {
            Date thisWeekStartDate = DateUtils.getThisWeekStartDate();
            Date thisWeekEndDate = DateUtils.getThisWeekEndDate();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object orgId = parameter.getCustomParam("org");
            if (orgId == null) {
                return;
            }
            this.getModel().setValue("org", orgId);
            this.getModel().setValue("daterange_startdate", (Object)thisWeekStartDate);
            this.getModel().setValue("daterange_enddate", (Object)thisWeekEndDate);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.buildRecentScheme(org, thisWeekStartDate, thisWeekEndDate);
            List<ABCAnalysisInfo> abcAnalysisInfos = this.buildFilterAndQueryData(orgId, thisWeekStartDate, thisWeekEndDate);
            if (abcAnalysisInfos.isEmpty()) {
                this.clearChartAndCount();
                return;
            }
            this.setABCCount(abcAnalysisInfos);
            this.buildPieChart(abcAnalysisInfos);
            this.buildBarChart(abcAnalysisInfos);
        } else {
            List<ABCAnalysisInfo> abcAnalysisInfos = this.setFilterFromScheme(scheme);
            if (abcAnalysisInfos.isEmpty()) {
                this.clearChartAndCount();
                return;
            }
            this.setABCCount(abcAnalysisInfos);
            this.buildPieChart(abcAnalysisInfos);
            this.buildBarChart(abcAnalysisInfos);
        }
        this.getView().updateView();
    }

    private List<ABCAnalysisInfo> buildFilterAndQueryData(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = this.buildFilter(orgId, startDate, endDate);
        Map<String, BigDecimal> abcRate = this.getABCRate();
        return this.queryData(qFilter, abcRate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "org": 
            case "daterange_startdate": 
            case "daterange_enddate": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                Date startDate = (Date)this.getModel().getValue("daterange_startdate");
                Date endDate = (Date)this.getModel().getValue("daterange_enddate");
                if (org == null || startDate == null || endDate == null) {
                    this.clearChartAndCount();
                    break;
                }
                Object orgId = org.getPkValue();
                QFilter qFilter = this.buildFilter(orgId, startDate, endDate);
                Map<String, BigDecimal> abcRate = this.getABCRate();
                this.buildRecentScheme(org, startDate, endDate);
                DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)this.getFormKey());
                this.getModel().setValue("schemeid", scheme.getPkValue());
                String schemeName = scheme.getString("schemename");
                kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl("labelap4");
                label.setText(schemeName);
                List<ABCAnalysisInfo> abcAnalysisInfos = this.queryData(qFilter, abcRate);
                if (abcAnalysisInfos.isEmpty()) {
                    this.clearChartAndCount();
                    break;
                }
                this.setABCCount(abcAnalysisInfos);
                this.buildPieChart(abcAnalysisInfos);
                this.buildBarChart(abcAnalysisInfos);
                this.getView().updateView();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String opKey = source.getKey();
        if ("filtercondition".equals(opKey) || "vectorap".equals(opKey)) {
            this.linkToFilterPage();
        } else if ("analysisdetail".equals(opKey) || "vectorap1".equals(opKey)) {
            this.linkToDetailPage();
        } else if ("selectscheme".equals(opKey)) {
            this.linkToSchemePage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectscheme".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            DynamicObject scheme = SchemeOpHelper.getSingleScheme((Long)Long.valueOf(String.valueOf(returnData)));
            List<ABCAnalysisInfo> abcAnalysisInfos = this.setFilterFromScheme(scheme);
            String schemeName = scheme.getString("schemename");
            kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl("labelap4");
            label.setText(schemeName);
            if (abcAnalysisInfos.isEmpty()) {
                return;
            }
            this.setABCCount(abcAnalysisInfos);
            this.buildPieChart(abcAnalysisInfos);
            this.buildBarChart(abcAnalysisInfos);
            this.getView().updateView();
        }
    }

    public abstract List<ABCAnalysisInfo> queryData(QFilter var1, Map<String, BigDecimal> var2);

    public abstract String getFormKey();

    public abstract String getFilterFormId();

    public abstract void linkToDetailPage();

    public abstract void linkToSchemePage();

    public void linkToFilterPage() {
        Map<String, Object> map = this.buildParams();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(this.getFilterFormId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        Object schemeId = this.getModel().getValue("schemeid");
        if (schemeId != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(schemeId))) {
            map.put("schemeId", schemeId);
        }
        formShowParameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void buildRecentScheme(DynamicObject org, Date startDate, Date endDate) {
        DynamicObject filterEntity = BusinessDataServiceHelper.newDynamicObject((String)this.getFilterFormId());
        filterEntity.set("org", (Object)org);
        filterEntity.set("daterange_startdate", (Object)startDate);
        filterEntity.set("daterange_enddate", (Object)endDate);
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            filterEntity.set(info.getSign(), this.getModel().getValue(info.getSign()));
        }
        String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{filterEntity}, (DynamicObjectType)filterEntity.getDynamicObjectType());
        String description = this.handleDescription(filterEntity);
        SchemeOpHelper.saveRecentScheme((String)this.getFormKey(), (String)content, (String)description);
    }

    public List<ABCAnalysisInfo> setFilterFromScheme(DynamicObject scheme) {
        String filterContent = scheme.getString("content_tag");
        DynamicObject newFilter = BusinessDataServiceHelper.newDynamicObject((String)this.getFilterFormId());
        Object[] entityArr = DynamicObjectSerializeUtil.deserialize((String)filterContent, (DynamicObjectType)newFilter.getDynamicObjectType());
        DynamicObject filterDyn = (DynamicObject)entityArr[0];
        DynamicObject org = filterDyn.getDynamicObject("org");
        Date startDate = filterDyn.getDate("daterange_startdate");
        Date endDate = filterDyn.getDate("daterange_enddate");
        IDataModel model = this.getModel();
        model.setValue("org", org.getPkValue());
        model.setValue("daterange_startdate", (Object)startDate);
        model.setValue("daterange_enddate", (Object)endDate);
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            BigDecimal rate = filterDyn.getBigDecimal(info.getSign());
            model.setValue(info.getSign(), (Object)rate);
        }
        model.setValue("schemeid", scheme.getPkValue());
        return this.buildFilterAndQueryData(org.getPkValue(), startDate, endDate);
    }

    protected void clearChartAndCount() {
        this.buildPieChartWithoutData();
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            this.getModel().setValue(info.getCountSign(), (Object)0);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap12"});
        this.getView().updateView("piechartap");
    }

    private void buildPieChartWithoutData() {
        PieChart pieChart = (PieChart)this.getView().getControl("piechartap");
        pieChart.clearData();
        PieSeries pieSeries = pieChart.createSeries(ResManager.loadKDString((String)"ABC\u5206\u6790", (String)"ABCAnalysisFilterPlugin_buildPieChartWithoutData_0", (String)"scmc-mobpm-form", (Object[])new Object[0]));
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            pieSeries.addData(info.getName(), (Number)BigDecimal.ZERO, info.getColor());
        }
        pieSeries.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setColor("#666666");
        label.setFormatter("{b}:{d}%");
        pieSeries.setLabel(label);
    }

    protected QFilter buildFilter(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("billentry.curamountandtax", "<>", (Object)BigDecimal.ZERO));
        return qFilter;
    }

    protected Map<String, BigDecimal> getABCRate() {
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(3);
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            BigDecimal rate = (BigDecimal)this.getModel().getValue(info.getSign());
            rateMap.put(info.getSign(), rate);
        }
        return rateMap;
    }

    protected List<String> getLabelColorList() {
        ArrayList<String> labelColorList = new ArrayList<String>(10);
        labelColorList.add("#DBE1FB");
        labelColorList.add("#966DDB");
        labelColorList.add("#F273B5");
        labelColorList.add("#6682F5");
        labelColorList.add("#40A9FF");
        labelColorList.add("#45DAD1");
        labelColorList.add("#73D13D");
        labelColorList.add("#FFD666");
        labelColorList.add("#FFA940");
        labelColorList.add("#F57582");
        return labelColorList;
    }

    protected void buildPieChart(List<ABCAnalysisInfo> abcAnalysisInfos) {
        Control pieChartAp = this.getView().getControl("piechartap");
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart == null) {
            return;
        }
        pieChart.clearData();
        PieSeries pieSeries = pieChart.createSeries("");
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            Optional<BigDecimal> rate = abcAnalysisInfos.stream().filter(sup -> Objects.equals(sup.getGroup(), info.getValue())).map(ABCAnalysisInfo::getPurProportion).reduce(BigDecimal::add);
            rate.ifPresent(bigDecimal -> pieSeries.addData(info.getName(), (Number)bigDecimal, info.getColor()));
        }
        pieSeries.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setColor("#666666");
        label.setFormatter("{b}:{d}%");
        pieSeries.setLabel(label);
    }

    protected void buildBarChart(List<ABCAnalysisInfo> abcAnalysisInfos) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap12"});
        Control barChartAp = this.getView().getControl("barchartap");
        BarChart barChart = null;
        if (barChartAp instanceof BarChart) {
            barChart = (BarChart)barChartAp;
        }
        if (barChart == null) {
            return;
        }
        barChart.clearData();
        List supplierColl = abcAnalysisInfos.stream().limit(10L).collect(Collectors.toList());
        Collections.reverse(supplierColl);
        List supplierNameColl = supplierColl.stream().map(ABCAnalysisInfo::getBaseDataName).collect(Collectors.toList());
        List<String> supplierNames = supplierNameColl.stream().map(x -> x != null && x.length() > 8 ? x.substring(0, 7) + "..." : x).collect(Collectors.toList());
        List<String> labelColorList = this.getLabelColorList();
        this.buildYAxisByNumChart(barChart, supplierNames);
        barChart.setMargin(Position.top, "5%");
        BarSeries barSeries = barChart.createSeries("");
        for (int i = 0; i < supplierColl.size(); ++i) {
            barSeries.addData(supplierNames.get(i), (Number)((ABCAnalysisInfo)supplierColl.get(i)).getAmount(), labelColorList.get(i));
        }
        barSeries.setBarWidth("30%");
        int[] radius = new int[]{0, 20, 20, 0};
        HashMap<String, int[]> itemStyle = new HashMap<String, int[]>(3);
        itemStyle.put("borderRadius", radius);
        barSeries.setPropValue("itemStyle", itemStyle);
        BigDecimal maxAmount = abcAnalysisInfos.get(0).getAmount();
        String sign = abcAnalysisInfos.get(0).getSign();
        this.buildXAxisByNumChart(barChart, maxAmount);
        Label label = new Label();
        label.setShow(true);
        label.setFormatter(sign + "{c}");
        label.setPosition(Position.right);
        label.setBorderRadius("10px");
        label.setColor("#666666");
        barSeries.setLabel(label);
    }

    protected void setABCCount(List<ABCAnalysisInfo> abcAnalysisInfos) {
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            long count = abcAnalysisInfos.stream().filter(sup -> Objects.equals(sup.getGroup(), info.getValue())).count();
            this.getModel().setValue(info.getCountSign(), (Object)count);
        }
    }

    protected void buildYAxisByNumChart(BarChart barChart, List<String> nameColl) {
        Axis yAxis = barChart.createYAxis("", AxisType.category);
        yAxis.setCategorys(nameColl.toArray(new String[0]));
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisShowMap);
        LinkedHashMap<String, Object> axisLabelMap = new LinkedHashMap<String, Object>(3);
        axisLabelMap.put("fontSize", 10);
        axisLabelMap.put("color", "#999999");
        axisLabelMap.put("width", 10);
        axisLabelMap.put("overflow", "break");
        yAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("axisLine", axisLine);
    }

    protected void buildXAxisByNumChart(BarChart barChart, BigDecimal maxAmount) {
        BigDecimal amount = maxAmount.multiply(new BigDecimal("1.5"));
        Axis xAxis = barChart.createXAxis("", AxisType.value);
        xAxis.setPropValue("show", (Object)false);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisShowMap);
        xAxis.setPropValue("axisTick", axisShowMap);
        xAxis.setPropValue("max", (Object)amount);
    }

    protected Map<String, Object> buildParams() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        map.put("org", org.getPkValue());
        map.put("startdate", this.getModel().getValue("daterange_startdate"));
        map.put("enddate", this.getModel().getValue("daterange_enddate"));
        for (ABCInfoEnum info : ABCInfoEnum.values()) {
            map.put(info.getSign(), this.getModel().getValue(info.getSign()));
        }
        return map;
    }

    private String handleDescription(DynamicObject entity) {
        ArrayList<String> description = new ArrayList<String>(3);
        DynamicObject org = entity.getDynamicObject("org");
        description.add(org.getString("name"));
        Date startDate = entity.getDate("daterange_startdate");
        Date endDate = entity.getDate("daterange_enddate");
        String startDateToString = DateUtils.getDateToString((Date)startDate, (boolean)false);
        String endDateToString = DateUtils.getDateToString((Date)endDate, (boolean)false);
        String dateToString = startDateToString + "~" + endDateToString;
        description.add(dateToString);
        BigDecimal rankARate = entity.getBigDecimal("rate_a");
        BigDecimal rankBRate = entity.getBigDecimal("rate_b");
        BigDecimal rankCRate = entity.getBigDecimal("rate_c");
        String abcRate = String.format("A:B:C=%s:%s:%s", rankARate, rankBRate, rankCRate);
        description.add(abcRate);
        return StringUtils.join(description, (String)";");
    }
}

