/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.puranalysis;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobpm.pojo.ABCAnalysisInfo;

public class PurAnalysisQueryDataPlugin {
    public static List<ABCAnalysisInfo> querySupplierABCAnalysisData(String className, QFilter qFilter, Map<String, BigDecimal> rateMap) {
        BigDecimal allAmount = new BigDecimal(0);
        BigDecimal rankARate = rateMap.get("rate_a");
        BigDecimal rankBRate = rateMap.get("rate_b");
        String selectField = PurAnalysisQueryDataPlugin.getSupplierSelectField();
        DataSet purOrderData = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)selectField, (QFilter[])new QFilter[]{qFilter}, null);
        DataSet purOrderGroupBySupplier = purOrderData.groupBy(new String[]{"supplier", "suppliername", "currency", "currencynum", "sign"}).sum("amount").finish().orderBy(new String[]{"amount desc"});
        DataSet allAmountData = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)"billentry.curamountandtax as allamount", (QFilter[])new QFilter[]{qFilter}, null).groupBy().sum("allamount").finish();
        for (Row row : allAmountData) {
            allAmount = row.getBigDecimal("allamount");
        }
        String supplierShowField = "supplier,suppliername,amount, currency,currencynum,sign, amount / " + allAmount + " * 100  as purproportion";
        DataSet select = purOrderGroupBySupplier.select(supplierShowField);
        ArrayList<ABCAnalysisInfo> list = new ArrayList<ABCAnalysisInfo>();
        BigDecimal purProportion = BigDecimal.ZERO;
        for (Row row : select) {
            ABCAnalysisInfo supplierABCInfo = new ABCAnalysisInfo();
            supplierABCInfo.setBaseData(row.getLong("supplier"));
            supplierABCInfo.setBaseDataName(row.getString("suppliername"));
            supplierABCInfo.setAmount(row.getBigDecimal("amount"));
            supplierABCInfo.setPurProportion(row.getBigDecimal("purproportion"));
            supplierABCInfo.setCurrency(row.getLong("currency"));
            supplierABCInfo.setCurrencyNum(row.getString("currencynum"));
            supplierABCInfo.setSign(row.getString("sign"));
            purProportion = purProportion.add(row.getBigDecimal("purproportion"));
            BigDecimal rowPurProportion = row.getBigDecimal("purproportion");
            if (purProportion.compareTo(rankARate) < 0) {
                supplierABCInfo.setGroup("A");
            } else if (purProportion.compareTo(rankARate) >= 0 && purProportion.subtract(rowPurProportion).compareTo(rankARate) < 0) {
                supplierABCInfo.setGroup("A");
            } else if (purProportion.compareTo(rankARate) >= 0 && purProportion.subtract(rowPurProportion).compareTo(rankBRate.add(rankARate)) < 0) {
                supplierABCInfo.setGroup("B");
            } else {
                supplierABCInfo.setGroup("C");
            }
            list.add(supplierABCInfo);
        }
        return list;
    }

    public static String getSupplierSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(6);
        selectorSet.add("supplier");
        selectorSet.add("supplier.name as suppliername");
        selectorSet.add("billentry.curamountandtax as amount");
        selectorSet.add("currency");
        selectorSet.add("currency.number as currencynum");
        selectorSet.add("currency.sign as sign");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<ABCAnalysisInfo> queryMaterialABCAnalysisData(String className, QFilter qFilter, Map<String, BigDecimal> rateMap) {
        BigDecimal allAmount = new BigDecimal(0);
        BigDecimal rankARate = rateMap.get("rate_a");
        BigDecimal rankBRate = rateMap.get("rate_b");
        String selectField = PurAnalysisQueryDataPlugin.getMaterialSelectField();
        DataSet purOrder = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)selectField, (QFilter[])new QFilter[]{qFilter}, null);
        DataSet dataSet = purOrder.groupBy(new String[]{"material", "materialname", "currency", "currencynum", "sign"}).sum("amount").finish().orderBy(new String[]{"amount desc"});
        DataSet amount = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)"billentry.curamountandtax as allamount", (QFilter[])new QFilter[]{qFilter}, null).groupBy().sum("allamount").finish();
        for (Row row : amount) {
            allAmount = row.getBigDecimal("allamount");
        }
        String materialShowField = "material,materialname,amount,currency,currencynum,sign,amount / " + allAmount + " * 100  as purproportion";
        DataSet copy = dataSet.select(materialShowField);
        ArrayList<ABCAnalysisInfo> list = new ArrayList<ABCAnalysisInfo>();
        BigDecimal purProportion = BigDecimal.ZERO;
        for (Row row : copy) {
            ABCAnalysisInfo materialABCInfo = new ABCAnalysisInfo();
            materialABCInfo.setBaseData(row.getLong("material"));
            materialABCInfo.setBaseDataName(row.getString("materialname"));
            materialABCInfo.setAmount(row.getBigDecimal("amount"));
            materialABCInfo.setCurrency(row.getLong("currency"));
            materialABCInfo.setPurProportion(row.getBigDecimal("purproportion"));
            materialABCInfo.setCurrencyNum(row.getString("currencynum"));
            materialABCInfo.setSign(row.getString("sign"));
            purProportion = purProportion.add(row.getBigDecimal("purproportion"));
            BigDecimal rowPurProportion = row.getBigDecimal("purproportion");
            if (purProportion.compareTo(rankARate) < 0) {
                materialABCInfo.setGroup("A");
            } else if (purProportion.compareTo(rankARate) >= 0 && purProportion.subtract(rowPurProportion).compareTo(rankARate) < 0) {
                materialABCInfo.setGroup("A");
            } else if (purProportion.compareTo(rankARate) >= 0 && purProportion.subtract(rowPurProportion).compareTo(rankBRate.add(rankARate)) < 0) {
                materialABCInfo.setGroup("B");
            } else {
                materialABCInfo.setGroup("C");
            }
            list.add(materialABCInfo);
        }
        return list;
    }

    public static String getMaterialSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(6);
        selectorSet.add("billentry.material.masterid as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("billentry.curamountandtax as amount");
        selectorSet.add("currency as currency");
        selectorSet.add("currency.number as currencynum");
        selectorSet.add("currency.sign as sign");
        return String.join((CharSequence)",", selectorSet);
    }

    public static DataSet getTimelyReceiptRateData(String className, QFilter qFilter, QFilter qFilter1, Date startDate, Date endDate) {
        DataSet pm_purorder = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)"id,billentry.id as entryid,billentry.deliverdate as deliverydate,billentry.invqty as invqty,billentry.qty as qty,billentry.rowclosestatus as rowclosestatus,billentry.rowterminatestatus as rowterminatestatus,supplier as entry_supplier,supplier.name as suppliername,org as entry_purorg,closestatus", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet expiredataSet = pm_purorder.executeSql("select case when to_char(deliverydate,'yyyy-MM-dd') >= '" + PurAnalysisQueryDataPlugin.getStringDate(startDate) + "' and to_char(deliverydate,'yyyy-MM-dd') <= '" + PurAnalysisQueryDataPlugin.getStringDate(endDate) + "' then 1 else 0 end as expireordernum,entry_supplier,suppliername,entry_purorg");
        DataSet expireordernum = expiredataSet.groupBy(new String[]{"entry_supplier", "suppliername", "entry_purorg"}).sum("expireordernum").finish();
        DataSet today = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)PurAnalysisQueryDataPlugin.getSelectField(), (QFilter[])new QFilter[]{qFilter1}, null);
        DataSet todaynum = today.groupBy(new String[]{"entry_supplier", "suppliername", "entry_purorg"}).sum("todaynum").finish();
        String imSalOutSelectField = PurAnalysisQueryDataPlugin.getImSalOutSelectField();
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter biztype = new QFilter("biztype.number", "in", (Object)new String[]{"110", "130"});
        DataSet im_purinbill = QueryServiceHelper.queryDataSet((String)className, (String)"im_purinbill", (String)imSalOutSelectField, (QFilter[])new QFilter[]{billStatus.and(biztype)}, null);
        DataSet pm_purorderbill = QueryServiceHelper.queryDataSet((String)className, (String)"pm_purorderbill", (String)"id,billentry.id as entryid,billentry.deliverdate as deliverydate,billentry.invqty as invqty,billentry.qty as qty,billentry.rowclosestatus as rowclosestatus,billentry.rowterminatestatus as rowterminatestatus,supplier as entry_supplier,supplier.name as suppliername,org as entry_purorg,closestatus", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet finish1 = pm_purorderbill.join(im_purinbill, JoinType.LEFT).on("id", "srcbillid").on("entryid", "srcbillentryid").select(new String[]{"biztime", "entryid", "srcbillentryid"}).finish();
        DataSet biztime = finish1.groupBy(new String[]{"srcbillentryid"}).max("biztime").finish();
        finish1 = pm_purorderbill.join(biztime, JoinType.LEFT).on("entryid", "srcbillentryid").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "deliverydate", "invqty", "qty", "rowclosestatus", "rowterminatestatus", "biztime", "closestatus", "entryid", "srcbillentryid"}).finish();
        DataSet overdue = finish1.executeSql("select case when rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and closestatus = 'A' then 1 else 0 end as overduenum,entry_supplier,suppliername,entry_purorg");
        overdue = overdue.groupBy(new String[]{"entry_supplier", "suppliername", "entry_purorg"}).sum("overduenum").finish();
        expireordernum = expireordernum.join(overdue, JoinType.LEFT).on("entry_supplier", "entry_supplier").on("entry_purorg", "entry_purorg").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "expireordernum", "overduenum"}).finish();
        DataSet select = finish1.executeSql("select case when (deliverydate >= biztime and invqty >= qty) or (deliverydate >= biztime and invqty < qty and rowclosestatus = 'B') or (deliverydate >= biztime and invqty < qty and rowterminatestatus = 'B') or (closestatus = 'B' and invqty = 0) or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate >= biztime) then 1 else 0 end as ontimenum,entry_supplier,suppliername,entry_purorg,biztime,deliverydate");
        select = select.groupBy(new String[]{"entry_supplier", "suppliername", "entry_purorg"}).sum("ontimenum").finish();
        DataSet select1 = finish1.executeSql("select case when (deliverydate < biztime and invqty >= qty) or (deliverydate < biztime and invqty < qty and rowclosestatus = 'B')  or (deliverydate < biztime and invqty < qty and rowterminatestatus = 'B')  or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate < biztime) then 1 else 0 end as overnum,entry_supplier,suppliername,entry_purorg");
        select1 = select1.groupBy(new String[]{"entry_supplier", "suppliername", "entry_purorg"}).sum("overnum").finish();
        DataSet finish2 = select.join(select1, JoinType.LEFT).on("entry_supplier", "entry_supplier").on("entry_purorg", "entry_purorg").select(new String[]{"ontimenum", "overnum", "entry_supplier", "suppliername", "entry_purorg"}).finish();
        DataSet finish3 = expireordernum.join(finish2, JoinType.LEFT).on("entry_supplier", "entry_supplier").on("entry_purorg", "entry_purorg").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "expireordernum", "overduenum", "ontimenum", "overnum"}).finish();
        DataSet bothSet = finish3.copy().join(todaynum.copy(), JoinType.INNER).on("entry_supplier", "entry_supplier").on("entry_purorg", "entry_purorg").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "expireordernum", "overduenum", "ontimenum", "overnum"}, new String[]{"todaynum"}).finish();
        bothSet = bothSet.addField("'1'", "both");
        DataSet leftSet = finish3.join(bothSet, JoinType.LEFT).on("entry_supplier", "entry_supplier").on("entry_purorg", "entry_purorg").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "expireordernum", "overduenum", "ontimenum", "overnum"}, new String[]{"both", "todaynum"}).finish().where("both is null");
        leftSet = leftSet.where("expireordernum > 0 or overduenum > 0 or ontimenum > 0 or overnum > 0");
        DataSet rightSet = todaynum.join(bothSet, JoinType.LEFT).on("entry_supplier", "entry_supplier").on("entry_purorg", "entry_purorg").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "todaynum"}, new String[]{"both"}).finish().where("both is null and todaynum > 0");
        leftSet = leftSet.select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "expireordernum", "overduenum", "ontimenum", "overnum", "0 as todaynum", "'0' as both"});
        rightSet = rightSet.select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "0 as expireordernum", "0 as overduenum", "0 as ontimenum", "0 as overnum", "todaynum", "'0' as both"});
        DataSet totalSet = leftSet.union(bothSet).union(rightSet);
        return totalSet.select(PurAnalysisQueryDataPlugin.getShowFields()).orderBy(new String[]{"delivertimerate desc,entry_supplier"});
    }

    public static String getStringDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String getSelectField() {
        ArrayList<String> select = new ArrayList<String>(16);
        select.add("supplier as entry_supplier");
        select.add("supplier.name as suppliername");
        select.add("org as entry_purorg");
        select.add("id");
        select.add("closestatus");
        select.add("billentry.id as entryid");
        select.add("billentry.deliverdate as deliverydate");
        select.add("billentry.invqty as invqty");
        select.add("billentry.qty as qty");
        select.add("billentry.rowclosestatus as rowclosestatus");
        select.add("billentry.rowterminatestatus as rowterminatestatus");
        select.add("case when billentry.invqty < billentry.qty and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and closestatus = 'A' then 1 else 0 end as todaynum");
        select.add("case when closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.invqty < billentry.qty then 1 else 0 end as overduenum");
        return String.join((CharSequence)",", select);
    }

    public static String getImSalOutSelectField() {
        ArrayList<String> select = new ArrayList<String>(16);
        select.add("biztime");
        select.add("billentry.mainbillid as srcbillid");
        select.add("billentry.mainbillentryid as srcbillentryid");
        return String.join((CharSequence)",", select);
    }

    private static String getShowFields() {
        return "entry_supplier,suppliername,entry_purorg,expireordernum,todaynum,overduenum,ontimenum,overnum,case when expireordernum != 0 then ontimenum * 1.0 / expireordernum * 100.0 end as delivertimerate";
    }
}

