/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.puranalysis;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.mobpm.business.PermissionHelper;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.enums.SchemeEnum;
import kd.scmc.msmob.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class TimelyReceiptRateFilterPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"schemebtn", "savebtn", "querybtn"});
        BasedataEdit purOrgF7 = (BasedataEdit)this.getControl("org");
        purOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void click(EventObject evt) {
        String opKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (opKey = source.getKey()) {
            case "schemebtn": {
                this.linkToSchemePage();
                break;
            }
            case "savebtn": {
                boolean checkResult = this.inputLegalCheck();
                if (!checkResult) break;
                this.saveSchemeOp();
                break;
            }
            case "querybtn": {
                boolean checkResult1 = this.inputLegalCheck();
                if (!checkResult1) break;
                this.linkToAnalysisPage();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        String type;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("savebtn".equals(actionId) && "1".equals(type = (String)(returnData = (Map)closedCallBackEvent.getReturnData()).get("type"))) {
            String name = (String)returnData.get("name");
            DynamicObject entity = this.getModel().getDataEntity(true);
            boolean checkFilter = this.checkFilter(name);
            if (checkFilter) {
                String description = this.handleDescription(entity);
                String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{entity}, (DynamicObjectType)entity.getDynamicObjectType());
                Long id = SchemeOpHelper.saveScheme((String)"mobpm_timelyreceiptrate", (String)name, (String)content, (String)description);
                this.getPageCache().put("schemeId", String.valueOf(id));
                this.getPageCache().put("name", name);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("org".equals(name)) {
            FormShowParameter formShowParameter = evt.getFormShowParameter();
            List<Object> purOrgColl = PermissionHelper.getAllHasPermPurOrgs();
            formShowParameter.setCustomParam("range", purOrgColl);
        }
    }

    private void initData() {
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object schemeId = formShowParameter.getCustomParam("schemeId");
        if (schemeId == null || StringUtils.isEmpty((CharSequence)String.valueOf(schemeId))) {
            Date thisWeekStartDate = DateUtils.getThisWeekStartDate();
            Date thisWeekEndDate = DateUtils.getThisWeekEndDate();
            this.getModel().setValue("org", formShowParameter.getCustomParam("org"));
            this.getModel().setValue("daterange_startdate", (Object)thisWeekStartDate);
            this.getModel().setValue("daterange_enddate", (Object)thisWeekEndDate);
        } else {
            DynamicObject filterDyn;
            DynamicObject schemeDyn = SchemeOpHelper.getSingleScheme((Long)Long.valueOf(String.valueOf(schemeId)));
            this.getPageCache().put("schemeId", String.valueOf(schemeId));
            this.getPageCache().put("name", schemeDyn.getString("schemename"));
            String scheme = schemeDyn.getString("content_tag");
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            if (StringUtils.isNotEmpty((CharSequence)scheme)) {
                Object[] entityArr = DynamicObjectSerializeUtil.deserialize((String)scheme, (DynamicObjectType)dataEntityType);
                filterDyn = (DynamicObject)entityArr[0];
            } else {
                filterDyn = new DynamicObject((DynamicObjectType)dataEntityType);
            }
            DynamicObject org = filterDyn.getDynamicObject("org");
            Date startDate = filterDyn.getDate("daterange_startdate");
            Date endDate = filterDyn.getDate("daterange_enddate");
            if (org != null) {
                this.getModel().setValue("org", org.getPkValue());
            }
            this.getModel().setValue("daterange_startdate", (Object)startDate);
            this.getModel().setValue("daterange_enddate", (Object)endDate);
        }
    }

    private void linkToSchemePage() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("msmob_scheme_list");
        String schemeId = this.getPageCache().get("schemeId");
        if (StringUtils.isNotEmpty((CharSequence)schemeId)) {
            formShowParameter.setCustomParam("schemeId", (Object)Long.valueOf(schemeId));
        }
        formShowParameter.setCustomParam("formKey", (Object)"mobpm_timelyrecratefilter");
        formShowParameter.setCustomParam("schemetype", (Object)"mobpm_timelyreceiptrate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void saveSchemeOp() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mob_save_scheme");
        String name = this.getPageCache().get("name");
        formShowParameter.setCustomParam("name", (Object)name);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "savebtn");
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void linkToAnalysisPage() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        String description = this.handleDescription(entity);
        String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{entity}, (DynamicObjectType)entity.getDynamicObjectType());
        SchemeOpHelper.saveRecentScheme((String)"mobpm_timelyreceiptrate", (String)content, (String)description);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mobpm_timelyreceiptrate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private String handleDescription(DynamicObject entity) {
        ArrayList<String> description = new ArrayList<String>(2);
        DynamicObject org = entity.getDynamicObject("org");
        description.add(org.getString("name"));
        Date startDate = entity.getDate("daterange_startdate");
        Date endDate = entity.getDate("daterange_enddate");
        String startDateToString = DateUtils.getDateToString((Date)startDate, (boolean)false);
        String endDateToString = DateUtils.getDateToString((Date)endDate, (boolean)false);
        String dateToString = startDateToString + "~" + endDateToString;
        description.add(dateToString);
        return StringUtils.join(description, (String)";");
    }

    private boolean checkFilter(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ABCAnalysisFilterPlugin_1", (String)"scmc-mobpm-form", (Object[])new Object[0]));
            return false;
        }
        if (SchemeEnum.RECENT_SCHEME_NAME.getName().equals(name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a'\u6700\u8fd1\u65b9\u6848'\u3002", (String)"ABCAnalysisFilterPlugin_2", (String)"scmc-mobpm-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean inputLegalCheck() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ABCAnalysisFilterPlugin_0", (String)"scmc-mobpm-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

