/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobpm.plugin.form.puranalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.mobpm.common.utils.PurDateUtils;
import kd.scmc.mobpm.plugin.form.puranalysis.PurAnalysisQueryDataPlugin;
import kd.scmc.mobpm.pojo.TimelyReceiptRateInfo;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class TimelyReceiptRatePlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap3", "vectorap", "mobilesearchap", "selectscheme", "filtercondition"});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)"mobpm_timelyreceiptrate");
        if (scheme == null) {
            Date thisWeekStartDate = DateUtils.getThisWeekStartDate();
            Date thisWeekEndDate = DateUtils.getThisWeekEndDate();
            this.getModel().setValue("daterange_startdate", (Object)thisWeekStartDate);
            this.getModel().setValue("daterange_enddate", (Object)thisWeekEndDate);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object orgId = parameter.getCustomParam("org");
            if (orgId == null) {
                return;
            }
            this.getModel().setValue("org", orgId);
            Date startDate = PurDateUtils.getStartOrEndDate(thisWeekStartDate, false);
            Date endDate = PurDateUtils.getStartOrEndDate(thisWeekEndDate, true);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.buildRecentScheme(org, thisWeekStartDate, thisWeekEndDate);
            QFilter expireFilter = this.getExpireFilter(orgId, startDate, endDate);
            QFilter todayFilter = this.getTodayFilter(orgId);
            List<TimelyReceiptRateInfo> timelyReceiptRateInfos = this.queryAndAssembleData(expireFilter, todayFilter, startDate, endDate);
            if (!timelyReceiptRateInfos.isEmpty()) {
                this.setDataValue(timelyReceiptRateInfos);
                this.getPageCache().put("showEntryList", JsonUtil.encodeToString(timelyReceiptRateInfos));
            } else {
                this.getPageCache().put("showEntryList", "empty");
            }
        } else {
            List<TimelyReceiptRateInfo> timelyReceiptRateInfos = this.setFilterFromScheme(scheme);
            if (!timelyReceiptRateInfos.isEmpty()) {
                this.setDataValue(timelyReceiptRateInfos);
                this.getPageCache().put("showEntryList", JsonUtil.encodeToString(timelyReceiptRateInfos));
            } else {
                this.getPageCache().put("showEntryList", "empty");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "org": 
            case "daterange_startdate": 
            case "daterange_enddate": {
                this.changeData();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("flexpanelap3".equals(key) || "vectorap".equals(key)) {
            this.sortEntryData();
        } else if ("filtercondition".equals(key)) {
            this.linkToFilterPage();
        } else if ("selectscheme".equals(key)) {
            this.linkToSchemePage();
        }
    }

    public void buildRecentScheme(DynamicObject org, Date startDate, Date endDate) {
        DynamicObject filterEntity = BusinessDataServiceHelper.newDynamicObject((String)"mobpm_timelyrecratefilter");
        filterEntity.set("org", (Object)org);
        filterEntity.set("daterange_startdate", (Object)startDate);
        filterEntity.set("daterange_enddate", (Object)endDate);
        String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{filterEntity}, (DynamicObjectType)filterEntity.getDynamicObjectType());
        String description = this.handleDescription(filterEntity);
        SchemeOpHelper.saveRecentScheme((String)"mobpm_timelyreceiptrate", (String)content, (String)description);
    }

    public List<TimelyReceiptRateInfo> setFilterFromScheme(DynamicObject scheme) {
        String filterContent = scheme.getString("content_tag");
        DynamicObject newFilter = BusinessDataServiceHelper.newDynamicObject((String)"mobpm_timelyrecratefilter");
        Object[] entityArr = DynamicObjectSerializeUtil.deserialize((String)filterContent, (DynamicObjectType)newFilter.getDynamicObjectType());
        DynamicObject filterDyn = (DynamicObject)entityArr[0];
        DynamicObject org = filterDyn.getDynamicObject("org");
        Date startDate = filterDyn.getDate("daterange_startdate");
        Date endDate = filterDyn.getDate("daterange_enddate");
        IDataModel model = this.getModel();
        model.setValue("org", org.getPkValue());
        model.setValue("daterange_startdate", (Object)startDate);
        model.setValue("daterange_enddate", (Object)endDate);
        model.setValue("schemeid", scheme.getPkValue());
        QFilter expireFilter = this.getExpireFilter(org.getPkValue(), startDate, endDate);
        QFilter todayFilter = this.getTodayFilter(org.getPkValue());
        return this.queryAndAssembleData(expireFilter, todayFilter, startDate, endDate);
    }

    private void linkToSchemePage() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("frequently_scheme_list");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectscheme"));
        Object schemeId = this.getModel().getValue("schemeid");
        if (schemeId != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(schemeId))) {
            formShowParameter.setCustomParam("schemeId", (Object)Long.valueOf(String.valueOf(schemeId)));
        }
        formShowParameter.setCustomParam("formKey", (Object)"mobpm_timelyrecratefilter");
        formShowParameter.setCustomParam("schemetype", (Object)"mobpm_timelyreceiptrate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void linkToFilterPage() {
        Object schemeId;
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mobpm_timelyrecratefilter");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            formShowParameter.setCustomParam("org", org.getPkValue());
        }
        if ((schemeId = this.getModel().getValue("schemeid")) != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(schemeId))) {
            formShowParameter.setCustomParam("schemeId", (Object)Long.valueOf(String.valueOf(schemeId)));
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectscheme".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            DynamicObject scheme = SchemeOpHelper.getSingleScheme((Long)Long.valueOf(String.valueOf(returnData)));
            List<TimelyReceiptRateInfo> timelyReceiptRateInfos = this.setFilterFromScheme(scheme);
            String schemeName = scheme.getString("schemename");
            Label label = (Label)this.getView().getControl("labelap4");
            label.setText(schemeName);
            if (!timelyReceiptRateInfos.isEmpty()) {
                this.setDataValue(timelyReceiptRateInfos);
                this.getPageCache().put("showEntryList", JsonUtil.encodeToString(timelyReceiptRateInfos));
            } else {
                this.getPageCache().put("showEntryList", "empty");
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        int[] selectRows = grid.getSelectRows();
        EntryData entryData = grid.getEntryData();
        DynamicObject[] dataEntity = entryData.getDataEntitys();
        DynamicObject selectEntryData = dataEntity[selectRows[0]];
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mobpm_timelyrecratedetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            map.put("org", org.getString("name"));
        }
        map.put("suppliernum", selectEntryData.getDynamicObject("supplier").getString("number"));
        map.put("suppliername", selectEntryData.getDynamicObject("supplier").getString("name"));
        map.put("rate", selectEntryData.getBigDecimal("rate"));
        map.put("expireordernum", selectEntryData.getInt("expireordernum"));
        map.put("todaynum", selectEntryData.getInt("todaynum"));
        map.put("ontimenum", selectEntryData.getInt("ontimenum"));
        map.put("overduenum", selectEntryData.getInt("overduenum"));
        map.put("overnum", selectEntryData.getInt("overnum"));
        formShowParameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void focus() {
        this.getModel().deleteEntryData("entryentity");
        this.searchTimelyRateEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getModel().deleteEntryData("entryentity");
        this.searchTimelyRateEntry();
    }

    private QFilter getExpireFilter(Object orgId, Date startDate, Date endDate) {
        QFilter expireFilter = new QFilter("org", "=", orgId);
        expireFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        expireFilter.and(new QFilter("changestatus", "!=", (Object)"B"));
        expireFilter.and(new QFilter("biztype.number", "in", (Object)new String[]{"110", "130"}));
        expireFilter.and(new QFilter("billentry.deliverdate", ">=", (Object)startDate));
        expireFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)endDate));
        expireFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)TimeServiceHelper.today()));
        return expireFilter;
    }

    private QFilter getTodayFilter(Object orgId) {
        QFilter todayFilter = new QFilter("org", "=", orgId);
        todayFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        todayFilter.and(new QFilter("changestatus", "!=", (Object)"B"));
        todayFilter.and(new QFilter("biztype.number", "in", (Object)new String[]{"110", "130"}));
        todayFilter.and(new QFilter("billentry.deliverdate", "=", (Object)PurDateUtils.getDate(TimeServiceHelper.today())));
        todayFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)TimeServiceHelper.today()));
        return todayFilter;
    }

    private List<TimelyReceiptRateInfo> queryAndAssembleData(QFilter expireFilter, QFilter todayFilter, Date startDate, Date endDate) {
        ArrayList<TimelyReceiptRateInfo> list = new ArrayList<TimelyReceiptRateInfo>();
        int serial = 0;
        DataSet timelyReceiptRateData = PurAnalysisQueryDataPlugin.getTimelyReceiptRateData(((Object)((Object)this)).getClass().getName(), expireFilter, todayFilter, startDate, endDate);
        for (Row row : timelyReceiptRateData) {
            TimelyReceiptRateInfo timelyReceiptRateInfo = new TimelyReceiptRateInfo();
            timelyReceiptRateInfo.setSupplier(row.getLong("entry_supplier"));
            timelyReceiptRateInfo.setSupplierName(row.getString("suppliername"));
            timelyReceiptRateInfo.setOrg(row.getLong("entry_purorg"));
            timelyReceiptRateInfo.setTimelyReceiptRate(row.getBigDecimal("delivertimerate"));
            timelyReceiptRateInfo.setExpireOrderNum(row.getInteger("expireordernum"));
            timelyReceiptRateInfo.setTodayReceiptNum(row.getInteger("todaynum"));
            timelyReceiptRateInfo.setOnTimeReceiptNum(row.getInteger("ontimenum"));
            timelyReceiptRateInfo.setOverdueReceiptNum(row.getInteger("overduenum"));
            timelyReceiptRateInfo.setOverdueUnReceiptNum(row.getInteger("overnum"));
            timelyReceiptRateInfo.setSerial(++serial);
            list.add(timelyReceiptRateInfo);
        }
        return list;
    }

    private void changeData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date startDate = (Date)this.getModel().getValue("daterange_startdate");
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        if (org == null || startDate == null || endDate == null) {
            this.getPageCache().put("showEntryList", "empty");
        } else {
            this.buildRecentScheme(org, startDate, endDate);
            DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)"mobpm_timelyreceiptrate");
            this.getModel().setValue("schemeid", scheme.getPkValue());
            String schemeName = scheme.getString("schemename");
            Label label = (Label)this.getView().getControl("labelap4");
            label.setText(schemeName);
            QFilter expireFilter = this.getExpireFilter(org.getPkValue(), startDate, endDate);
            QFilter todayFilter = this.getTodayFilter(org.getPkValue());
            List<TimelyReceiptRateInfo> timelyReceiptRateInfos = this.queryAndAssembleData(expireFilter, todayFilter, startDate, endDate);
            if (!timelyReceiptRateInfos.isEmpty()) {
                MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
                if (search.getText() == null || search.getText().equals("")) {
                    this.setDataValue(timelyReceiptRateInfos);
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(timelyReceiptRateInfos));
                } else {
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(timelyReceiptRateInfos));
                    this.searchTimelyRateEntry();
                }
            } else {
                this.getModel().deleteEntryData("entryentity");
                this.getPageCache().put("showEntryList", "empty");
            }
        }
    }

    private void setDataValue(List<TimelyReceiptRateInfo> timelyReceiptRateInfos) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", timelyReceiptRateInfos.size());
        for (int index = 0; index < timelyReceiptRateInfos.size(); ++index) {
            TimelyReceiptRateInfo timelyReceiptRateInfo = timelyReceiptRateInfos.get(index);
            model.setValue("serial", (Object)timelyReceiptRateInfo.getSerial(), index);
            model.setValue("supplier", (Object)timelyReceiptRateInfo.getSupplier(), index);
            model.setValue("rate", (Object)timelyReceiptRateInfo.getTimelyReceiptRate(), index);
            model.setValue("expireordernum", (Object)timelyReceiptRateInfo.getExpireOrderNum(), index);
            model.setValue("todaynum", (Object)timelyReceiptRateInfo.getTodayReceiptNum(), index);
            model.setValue("ontimenum", (Object)timelyReceiptRateInfo.getOnTimeReceiptNum(), index);
            model.setValue("overduenum", (Object)timelyReceiptRateInfo.getOverdueReceiptNum(), index);
            model.setValue("overnum", (Object)timelyReceiptRateInfo.getOverdueUnReceiptNum(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void sortEntryData() {
        String tempEntryColl = this.getPageCache().get("tempEntryList");
        List entryRow = (List)JsonUtil.decodeFromString((String)tempEntryColl, List.class);
        if (entryRow == null || entryRow.isEmpty()) {
            String timelyReceiptRateEntryStr = this.getPageCache().get("showEntryList");
            if (timelyReceiptRateEntryStr.equals("empty")) {
                return;
            }
            entryRow = (List)JsonUtil.decodeFromString((String)timelyReceiptRateEntryStr, List.class);
        }
        ArrayList<TimelyReceiptRateInfo> timelyReceiptRateEntryList = new ArrayList<TimelyReceiptRateInfo>(entryRow.size());
        for (JSONObject jsonObject : entryRow) {
            TimelyReceiptRateInfo entry = (TimelyReceiptRateInfo)JSON.toJavaObject((JSON)jsonObject, TimelyReceiptRateInfo.class);
            timelyReceiptRateEntryList.add(entry);
        }
        String direct = this.getPageCache().get("sortDirection");
        if ("up".equals(direct)) {
            this.getPageCache().put("sortDirection", "down");
            timelyReceiptRateEntryList.sort((e1, e2) -> e2.getSerial().compareTo(e1.getSerial()));
        } else {
            this.getPageCache().put("sortDirection", "up");
            timelyReceiptRateEntryList.sort(Comparator.comparing(TimelyReceiptRateInfo::getSerial));
        }
        this.sortAndSearchSetData(timelyReceiptRateEntryList);
    }

    private void sortAndSearchSetData(List<TimelyReceiptRateInfo> timelyReceiptRateInfos) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (int index = 0; index < timelyReceiptRateInfos.size(); ++index) {
            TimelyReceiptRateInfo timelyReceiptRateInfo = timelyReceiptRateInfos.get(index);
            model.setValue("serial", (Object)timelyReceiptRateInfo.getSerial(), index);
            model.setValue("supplier", (Object)timelyReceiptRateInfo.getSupplier(), index);
            model.setValue("rate", (Object)timelyReceiptRateInfo.getTimelyReceiptRate(), index);
            model.setValue("expireordernum", (Object)timelyReceiptRateInfo.getExpireOrderNum(), index);
            model.setValue("todaynum", (Object)timelyReceiptRateInfo.getTodayReceiptNum(), index);
            model.setValue("ontimenum", (Object)timelyReceiptRateInfo.getOnTimeReceiptNum(), index);
            model.setValue("overduenum", (Object)timelyReceiptRateInfo.getOverdueReceiptNum(), index);
            model.setValue("overnum", (Object)timelyReceiptRateInfo.getOverdueUnReceiptNum(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void searchTimelyRateEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        String entryStr = this.getPageCache().get("showEntryList");
        if (entryStr == null || entryStr.equals("empty")) {
            return;
        }
        List entryList = (List)JsonUtil.decodeFromString((String)entryStr, List.class);
        ArrayList<TimelyReceiptRateInfo> showList = new ArrayList<TimelyReceiptRateInfo>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            TimelyReceiptRateInfo entry = (TimelyReceiptRateInfo)JSON.toJavaObject((JSON)jsonObject, TimelyReceiptRateInfo.class);
            if (!entry.getSupplierName().contains(search.getText())) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        if (!showList.isEmpty()) {
            this.setDataValue(showList);
        }
        int showCount = showList.size();
        for (i = 0; i < showList.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{"cardentryflexpanelap"});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"cardentryflexpanelap"});
        }
        this.getPageCache().put("tempEntryList", JsonUtil.encodeToString(showList));
    }

    private String handleDescription(DynamicObject entity) {
        ArrayList<String> description = new ArrayList<String>(2);
        DynamicObject org = entity.getDynamicObject("org");
        description.add(org.getString("name"));
        Date startDate = entity.getDate("daterange_startdate");
        Date endDate = entity.getDate("daterange_enddate");
        String startDateToString = DateUtils.getDateToString((Date)startDate, (boolean)false);
        String endDateToString = DateUtils.getDateToString((Date)endDate, (boolean)false);
        String dateToString = startDateToString + "~" + endDateToString;
        description.add(dateToString);
        return StringUtils.join(description, (String)";");
    }
}

