/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scmc.msmob.common.consts.SCMCBaseBillMobConst;
import kd.scmc.msmob.common.utils.BotpFilterUtils;

public class BotpFilterHelper {
    public static QFilter getAvailableRuleFilters(DynamicObject[] pcEntityArr, String srcEntityKey, String targetEntityKey, String targetMainEntryKey) {
        if (StringUtils.isEmpty((CharSequence)srcEntityKey) || StringUtils.isEmpty((CharSequence)targetEntityKey) || pcEntityArr == null || pcEntityArr.length == 0) {
            return new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        }
        List convertRuleElements = ConvertMetaServiceHelper.loadRules((String)srcEntityKey, (String)targetEntityKey);
        List<ListSelectedRow> selectedRows = BotpFilterHelper.getSelectedRows(pcEntityArr, targetMainEntryKey);
        ArrayList<String> availableRuleIds = new ArrayList<String>(10);
        for (ConvertRuleElement rule : convertRuleElements) {
            if (!rule.isEnabled()) continue;
            String ruleId = rule.getId();
            availableRuleIds.add(ruleId);
        }
        QFilter qFilter = null;
        if (availableRuleIds.isEmpty()) {
            qFilter = new QFilter("1", "!=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        } else {
            for (String ruleId : availableRuleIds) {
                QFilter filter = BotpFilterUtils.getConvertRuleFilters((String)srcEntityKey, (String)targetEntityKey, selectedRows, (String)ruleId);
                if (qFilter == null) {
                    qFilter = filter;
                    continue;
                }
                if (filter == null) continue;
                qFilter.and(filter);
            }
            if (qFilter == null) {
                qFilter = new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
            }
        }
        return qFilter;
    }

    private static List<ListSelectedRow> getSelectedRows(DynamicObject[] pcEntityArr, String targetMainEntryKey) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : pcEntityArr) {
            long billId = srcBill.getLong("id");
            if (StringUtils.isNotEmpty((CharSequence)targetMainEntryKey)) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)billId);
                selectedRows.add(row);
                continue;
            }
            DynamicObjectCollection entryRowColl = srcBill.getDynamicObjectCollection(targetMainEntryKey);
            for (DynamicObject entryRow : entryRowColl) {
                Long billEntryId = entryRow.getLong("id");
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)billId);
                row.setEntryEntityKey(targetMainEntryKey);
                row.setEntryPrimaryKeyValue((Object)billEntryId);
                selectedRows.add(row);
            }
        }
        return selectedRows;
    }
}

