/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.common.design.hompage.region;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.mobsm.business.helper.AppHomeFilterAndFieldHelper;
import kd.scmc.mobsm.common.utils.DateUtils;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.design.homepage.region.HomePageBuildDefaultDataRegion;
import kd.scmc.msmob.pojo.CardData;

public class MobsmNumberRegion
extends HomePageBuildDefaultDataRegion {
    private static final String CARD_VIEW = "2DUC=B5588VZ";

    public MobsmNumberRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setNumberDate();
        this.setNumberCard(this.getOrgId());
    }

    public void setNumberDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.add(2, 1);
        calendar.add(14, -1);
        Date endDate = calendar.getTime();
        this.getView().getModel().setValue("numbercaredate_startdate", (Object)startDate);
        this.getView().getModel().setValue("numbercaredate_enddate", (Object)endDate);
    }

    private boolean permissionNumberCard(Long orgId) {
        if (orgId != null) {
            return PermissionHelper.checkPermission((Long)orgId, (String)"mobsm", (String)"mobsm_apphome_new", (String)CARD_VIEW);
        }
        return false;
    }

    public void setNumberCard(Long orgId) {
        Label salesPerLab = (Label)this.getView().getControl("labelap4");
        Label receivableAmountLab = (Label)this.getView().getControl("labelap7");
        Label newCustomerLab = (Label)this.getView().getControl("labelap8");
        Date startDate = (Date)this.getView().getModel().getValue("numbercaredate_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("numbercaredate_enddate");
        if (orgId != null) {
            boolean permResult = this.permissionNumberCard(orgId);
            if (!permResult) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap2"});
                salesPerLab.setText("***");
                receivableAmountLab.setText("***");
                newCustomerLab.setText("***");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap2"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap"});
                QFilter[] qFilter = AppHomeFilterAndFieldHelper.qFilter(orgId, startDate, endDate);
                DataSet saleOrder = this.queryResult(AppHomeFilterAndFieldHelper.getSaleAmountField(), qFilter);
                DataSet dataSet = saleOrder.groupBy(new String[]{"orgname", "currency"}).sum("curtotalallamount").sum("receiptallamount").finish();
                if (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    BigDecimal curTotalalAamount = next.getBigDecimal("curtotalallamount");
                    BigDecimal receipTallAmount = next.getBigDecimal("receiptallamount");
                    salesPerLab.setText(curTotalalAamount.stripTrailingZeros().toPlainString());
                    receivableAmountLab.setText(receipTallAmount.stripTrailingZeros().toPlainString());
                } else {
                    salesPerLab.setText("0");
                    receivableAmountLab.setText("0");
                }
                int newCustomer = this.getNewCustomer(orgId, startDate, endDate);
                newCustomerLab.setText(newCustomer + "");
            }
        }
    }

    private DataSet queryResult(String queryFieldKey, QFilter[] qFilters) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)queryFieldKey, (QFilter[])qFilters, null);
    }

    public int getNewCustomer(Long curSaleOrgId, Date startDate, Date endDate) {
        Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDate(endDate);
        Date custEndDate = startAndEndDate.get("enddate");
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)curSaleOrgId);
        qFilter.and(new QFilter("createorg", "=", (Object)curSaleOrgId));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)custEndDate));
        DataSet newCustomer = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_customer", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null);
        int count = newCustomer.count("id", false);
        return count;
    }
}

