/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.common.design.hompage.region;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobsm.common.utils.DateUtils;
import kd.scmc.msmob.common.design.homepage.CheckPermissionCalculator;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionMultipleRegion;
import kd.scmc.msmob.pojo.CardData;
import kd.scmc.msmob.pojo.ControlPermInfo;
import kd.scmc.msmob.pojo.PermItemInfo;

public class MobsmToDoBusinessRegion
extends CheckPermissionMultipleRegion {
    public MobsmToDoBusinessRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public Map<String, Boolean> checkPermission() {
        return CheckPermissionCalculator.checkPermission((Long)this.getOrgId(), (String)"sm", this.getControlPermItems());
    }

    public List<ControlPermInfo> getControlPermItems() {
        return Arrays.asList(new ControlPermInfo("submitsaleorderflex", "03", Collections.singletonList(new PermItemInfo("sm_salorder", Collections.singletonList("47150e89000000ac")))), new ControlPermInfo("submitdelivernoticeflex", "03", Collections.singletonList(new PermItemInfo("sm_delivernotice", Collections.singletonList("47150e89000000ac")))), new ControlPermInfo("submitreturnapplyflex", "03", Collections.singletonList(new PermItemInfo("sm_returnapply", Collections.singletonList("47150e89000000ac")))));
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setToDoBusinessCard(this.getOrgId());
    }

    public void setToDoBusinessCard(Long orgId) {
        Date startDate = (Date)this.getView().getModel().getValue("todobusiness_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("todobusiness_enddate");
        Label smOrderLab = (Label)this.getView().getControl("submitsaleordercount");
        Label smDeliverLab = (Label)this.getView().getControl("submitdelivernoticecount");
        Label smApplyLab = (Label)this.getView().getControl("submitreturnapplycount");
        this.setToDoBusinessText(orgId, "sm_salorder", startDate, endDate, smOrderLab);
        this.setToDoBusinessText(orgId, "sm_delivernotice", startDate, endDate, smDeliverLab);
        this.setToDoBusinessText(orgId, "sm_returnapply", startDate, endDate, smApplyLab);
    }

    private void setToDoBusinessText(Long orgId, String entityKey, Date startDate, Date endDate, Label label) {
        int billCount = this.getBillCount(orgId, entityKey, startDate, endDate);
        label.setText(billCount + "");
    }

    private int getBillCount(Long orgId, String entityName, Date startDate, Date endDate) {
        Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDate(endDate);
        Date custEndDate = startAndEndDate.get("enddate");
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("billstatus", "=", (Object)"B"));
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)custEndDate));
        DataSet billCount = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"id,billno,createtime", (QFilter[])new QFilter[]{qFilter}, null).distinct();
        int count = billCount.count("id", false);
        return count;
    }
}

