/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.common.utils;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    private static final String STRATDATE = "startdate";
    private static final String ENDDATE = "enddate";

    public static Map<String, Date> getStartAndEndDate(Date date) {
        HashMap<String, Date> startAndEndDate = new HashMap<String, Date>(2);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime startLocalDateTime = localDateTime.with(LocalTime.MIN);
        LocalDateTime endLocalDateTime = localDateTime.with(LocalTime.MAX);
        Date startOfDay = Date.from(startLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        Date endOfDay = Date.from(endLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        startAndEndDate.put(STRATDATE, startOfDay);
        startAndEndDate.put(ENDDATE, endOfDay);
        return startAndEndDate;
    }

    public static Map<String, Date> getStartAndEndDateOfWeek(Date date) {
        HashMap<String, Date> startAndEndDate = new HashMap<String, Date>(2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        startAndEndDate.put(STRATDATE, cal.getTime());
        cal.add(5, 6);
        startAndEndDate.put(ENDDATE, cal.getTime());
        return startAndEndDate;
    }
}

