/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.RefreshResultType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mvc.form.MobileFormView;
import kd.scmc.mobsm.business.helper.CustomerPropChartHelper;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.design.hompage.handle.MobsmHomePageBuilder;
import kd.scmc.mobsm.common.design.hompage.region.MobsmDatAnalysisRegion;
import kd.scmc.mobsm.common.utils.PageUtils;
import kd.scmc.mobsm.plugin.form.AppHomeClick;
import kd.scmc.mobsm.plugin.form.dataanalysis.customervalue.CustomerValueHomeData;
import kd.scmc.msmob.common.design.homepage.handle.HomePageBuilder;
import kd.scmc.msmob.plugin.tpl.basetpl.home.AbstractMobAppHomeBaseTplPlugin;
import kd.scmc.msmob.pojo.CardData;

public class AppHomeNewPlugin
extends AbstractMobAppHomeBaseTplPlugin {
    private Map<String, Integer> custLabelNumMap;
    private List<String> custLabelList = CustomerPropChartHelper.getCustLabelList();
    private CustomerValueHomeData customerValueHomeData = new CustomerValueHomeData();
    public static String[] button = new String[]{"linktorfm", "linktorfmlab", "linktorfmflex", "submitdelivernoticeflex", "submitreturnapplyflex", "submitsaleorderflex"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AppHomeClick.addMenuItemClickListener((AbstractMobBillPlugIn)this);
        this.addClickListeners(button);
    }

    public void initEntityPermItem() {
    }

    public Map<String, Boolean> checkPermission(Long org) {
        return new HashMap<String, Boolean>(0);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCustomerPropChartWithOrg();
    }

    private void setCustomerPropChartWithOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = null;
        if (org != null) {
            orgId = org.getLong("id");
        }
        this.setCustomerPropChart(orgId);
    }

    public void refreshData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            this.buildHomePage(orgId);
            this.setCustomerPropChart(orgId);
        }
        ((MobileFormView)this.getView()).setRefreshResult(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"AppHomeNewPlugin_refreshData_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), Integer.valueOf(3000), RefreshResultType.Success);
    }

    public void setAgEndBusinessDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 0);
        Date endDate = calendar.getTime();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(2, -3);
        Date startDate = calendar.getTime();
        this.getModel().setValue("todobusiness_startdate", (Object)startDate);
        this.getModel().setValue("todobusiness_enddate", (Object)endDate);
    }

    public void setToDoBusinessCard(Long orgId) {
    }

    protected HomePageBuilder getHomePageBuilder() {
        return new MobsmHomePageBuilder(this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.setCustomerPropChartWithOrg();
    }

    private void setCustomerPropChart(Long orgId) {
        if (orgId == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"afterbusinessflex"});
            return;
        }
        MobsmDatAnalysisRegion mobsmDatAnalysisRegion = new MobsmDatAnalysisRegion(this.getView());
        boolean permResult = mobsmDatAnalysisRegion.singleCheckPermission();
        if (!this.isPresent(orgId).booleanValue() || !permResult) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"afterbusinessflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"afterbusinessflex"});
        this.getRfmSumData(orgId);
        Control pieChartAp = this.getView().getControl("custpropchart");
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart == null) {
            return;
        }
        pieChart.clearData();
        pieChart.setShowLegend(false);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("triggerOn", (Object)"click");
        PieSeries series = pieChart.createSeries("");
        List<String> labelColorList = CustomerPropChartHelper.getLabelColorList();
        for (int i = 0; i < this.custLabelList.size(); ++i) {
            String custLabel = this.custLabelList.get(i);
            series.addData(custLabel, (Number)this.custLabelNumMap.getOrDefault(custLabel, 0), labelColorList.get(i));
        }
        CustomerPropChartHelper.setControlText(this.getView(), "highvalnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getHighValueCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "wakeupnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getWakeUpCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "deepdignum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getDeepDigCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "retainnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getRetainCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "potentialnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getPotentialCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "newnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getNewCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "generalkeepnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getGeneralKeepCustomer(), 0).toString());
        CustomerPropChartHelper.setControlText(this.getView(), "losenum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getLoseCustomer(), 0).toString());
        series.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        label.setFormatter("{b} : {c}  ({d}%)");
        series.setLabel(label);
        this.getView().updateView("custpropchart");
    }

    public Boolean isPresent(Long orgId) {
        boolean invisible = this.getView().getControl("afterbusinessflex").isInvisible();
        CardData setting = this.getCardData(orgId);
        return !invisible && (setting == null || setting.getSelectedCards().stream().anyMatch(card -> card.getId().equals("afterbusinessflex")));
    }

    private void getRfmSumData(Long curSaleOrgId) {
        boolean flag = this.customerValueHomeData.getRfmSumData(curSaleOrgId);
        if (!flag) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0e\u6240\u9009\u9500\u552e\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AppHomeNewPlugin_2", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        }
        this.custLabelNumMap = this.customerValueHomeData.custLabelNumMap;
    }

    public String getShowBillKey() {
        return "mobsm_commonapp";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (proName) {
            case "org": {
                Long orgId = newValue == null ? null : Long.valueOf(((DynamicObject)newValue).getLong("id"));
                this.setCustomerPropChart(orgId);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        AppHomeClick.menuItemClick((AbstractMobBillPlugIn)this, evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        String opKey = control.getKey();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        HashMap<String, Object> customParams = new HashMap<String, Object>(3);
        customParams.put("org", orgId);
        switch (opKey) {
            case "linktorfm": 
            case "linktorfmlab": 
            case "linktorfmflex": {
                PageUtils.openFormPage(view, "mobsm_customeranalysis", customParams, null);
                break;
            }
            case "submitdelivernoticeflex": {
                this.openToDoListPage(view, customParams, "mobsm_delivernotice_list");
                break;
            }
            case "submitreturnapplyflex": {
                this.openToDoListPage(view, customParams, "mobsm_returnapply_list");
                break;
            }
            case "submitsaleorderflex": {
                this.openToDoListPage(view, customParams, "mobsm_salorder_list");
                break;
            }
        }
    }

    private void openToDoListPage(IFormView view, Map<String, Object> customParams, String mobListFormKey) {
        customParams.put("todoDate", "todoDate");
        PageUtils.openFormPage(view, mobListFormKey, customParams, null);
    }
}

