/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobsm.business.helper.PermissionHelper;
import kd.scmc.mobsm.common.entity.BizEntityPermItemInfo;
import kd.scmc.mobsm.common.entity.OpPermItemInfo;
import kd.scmc.mobsm.common.utils.FormUtils;
import kd.scmc.mobsm.common.utils.PageUtils;

public class AppHomePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private List<BizEntityPermItemInfo> entityPermCache = new ArrayList<BizEntityPermItemInfo>(10);
    private static final String IDENT_EQ_KEY = "1";
    private static final Integer IDENT_EQ_VAL = 1;
    private static final String SUBMIT_STATUS = "B";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, "org");
        FormUtils.addClickListener((ClickListener)this, "icon_saleorder", "icon_delivernotice", "customervalue", "icon_returnapply", "icon_outorder", "salorgrevanal", "prodsalpropanal", "newcustomeranal", "salperfrank", "salcollrank", "custorderdelrate", "custsalnews", "submitsaleorder", "submitdelivernotice");
    }

    public void initialize() {
        super.initialize();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setOrgFunc("15");
        this.initEntityPermItem();
    }

    private void initEntityPermItem() {
        BizEntityPermItemInfo sOrderPermItem = new BizEntityPermItemInfo();
        OpPermItemInfo orderVPermItem = new OpPermItemInfo();
        orderVPermItem.setItemKey("icon_saleorder");
        orderVPermItem.setPermItemId("47150e89000000ac");
        sOrderPermItem.setFormKey("sm_salorder");
        sOrderPermItem.setOpPermItemList(Collections.singletonList(orderVPermItem));
        BizEntityPermItemInfo deliverNPermItem = new BizEntityPermItemInfo();
        OpPermItemInfo deliverVPermItem = new OpPermItemInfo();
        deliverVPermItem.setItemKey("icon_delivernotice");
        deliverVPermItem.setPermItemId("47150e89000000ac");
        deliverNPermItem.setFormKey("sm_delivernotice");
        deliverNPermItem.setOpPermItemList(Collections.singletonList(deliverVPermItem));
        BizEntityPermItemInfo returnApplyPerm = new BizEntityPermItemInfo();
        OpPermItemInfo returnApplyItem = new OpPermItemInfo();
        returnApplyItem.setItemKey("icon_returnapply");
        returnApplyItem.setPermItemId("47150e89000000ac");
        returnApplyPerm.setFormKey("sm_returnapply");
        returnApplyPerm.setOpPermItemList(Collections.singletonList(returnApplyItem));
        BizEntityPermItemInfo salOutPerm = new BizEntityPermItemInfo();
        OpPermItemInfo salOutPermItem = new OpPermItemInfo();
        salOutPermItem.setItemKey("icon_outorder");
        salOutPermItem.setPermItemId("47150e89000000ac");
        salOutPerm.setFormKey("im_saloutbill");
        salOutPerm.setOpPermItemList(Collections.singletonList(salOutPermItem));
        BizEntityPermItemInfo customerNPermItem = new BizEntityPermItemInfo();
        OpPermItemInfo customerVPermItem = new OpPermItemInfo();
        customerVPermItem.setItemKey("customervalue");
        customerVPermItem.setPermItemId("47150e89000000ac");
        customerNPermItem.setFormKey("mobsm_customeranalysis");
        customerNPermItem.setOpPermItemList(Collections.singletonList(customerVPermItem));
        List<BizEntityPermItemInfo> saleAnalysisPermItemInfo = this.initSaleAnalysisPermItem();
        BizEntityPermItemInfo salOrderPermItem = new BizEntityPermItemInfo();
        OpPermItemInfo salOrderVPermItem = new OpPermItemInfo();
        salOrderVPermItem.setItemKey("submitsaleorder");
        salOrderVPermItem.setPermItemId("47150e89000000ac");
        salOrderPermItem.setFormKey("sm_salorder");
        salOrderPermItem.setOpPermItemList(Collections.singletonList(salOrderVPermItem));
        BizEntityPermItemInfo deliverNoticePermItem = new BizEntityPermItemInfo();
        OpPermItemInfo deliverViewPermItem = new OpPermItemInfo();
        deliverViewPermItem.setItemKey("submitdelivernotice");
        deliverViewPermItem.setPermItemId("47150e89000000ac");
        deliverNoticePermItem.setFormKey("sm_delivernotice");
        deliverNoticePermItem.setOpPermItemList(Collections.singletonList(deliverViewPermItem));
        this.entityPermCache.add(salOutPerm);
        this.entityPermCache.add(sOrderPermItem);
        this.entityPermCache.add(deliverNPermItem);
        this.entityPermCache.add(returnApplyPerm);
        this.entityPermCache.add(customerNPermItem);
        this.entityPermCache.add(salOrderPermItem);
        this.entityPermCache.add(deliverNoticePermItem);
        this.entityPermCache.addAll(saleAnalysisPermItemInfo);
    }

    private List<BizEntityPermItemInfo> initSaleAnalysisPermItem() {
        ArrayList<BizEntityPermItemInfo> saleAnalysisPermItemInfo = new ArrayList<BizEntityPermItemInfo>(10);
        BizEntityPermItemInfo salOrgRevAnalPerm = new BizEntityPermItemInfo();
        OpPermItemInfo salOrgRevAnalPermItem = new OpPermItemInfo();
        salOrgRevAnalPermItem.setItemKey("salorgrevanal");
        salOrgRevAnalPermItem.setPermItemId("47150e89000000ac");
        salOrgRevAnalPerm.setFormKey("mobsm_salorgrevanal");
        salOrgRevAnalPerm.setOpPermItemList(Collections.singletonList(salOrgRevAnalPermItem));
        saleAnalysisPermItemInfo.add(salOrgRevAnalPerm);
        BizEntityPermItemInfo prodSalPropAnalPerm = new BizEntityPermItemInfo();
        OpPermItemInfo prodSalPropAnalPermItem = new OpPermItemInfo();
        prodSalPropAnalPermItem.setItemKey("prodsalpropanal");
        prodSalPropAnalPermItem.setPermItemId("47150e89000000ac");
        prodSalPropAnalPerm.setFormKey("mobsm_prodsalpropanal");
        prodSalPropAnalPerm.setOpPermItemList(Collections.singletonList(prodSalPropAnalPermItem));
        saleAnalysisPermItemInfo.add(prodSalPropAnalPerm);
        BizEntityPermItemInfo newCustAnalPerm = new BizEntityPermItemInfo();
        OpPermItemInfo newCustAnalPermItem = new OpPermItemInfo();
        newCustAnalPermItem.setItemKey("newcustomeranal");
        newCustAnalPermItem.setPermItemId("47150e89000000ac");
        newCustAnalPerm.setFormKey("mobsm_newcustomeranal");
        newCustAnalPerm.setOpPermItemList(Collections.singletonList(newCustAnalPermItem));
        saleAnalysisPermItemInfo.add(newCustAnalPerm);
        BizEntityPermItemInfo salPerfRankPerm = new BizEntityPermItemInfo();
        OpPermItemInfo salPerfRankPermItem = new OpPermItemInfo();
        salPerfRankPermItem.setItemKey("salperfrank");
        salPerfRankPermItem.setPermItemId("47150e89000000ac");
        salPerfRankPerm.setFormKey("mobsm_salperfrank");
        salPerfRankPerm.setOpPermItemList(Collections.singletonList(salPerfRankPermItem));
        saleAnalysisPermItemInfo.add(salPerfRankPerm);
        BizEntityPermItemInfo salCollRankPerm = new BizEntityPermItemInfo();
        OpPermItemInfo salCollRankPermItem = new OpPermItemInfo();
        salCollRankPermItem.setItemKey("salcollrank");
        salCollRankPermItem.setPermItemId("47150e89000000ac");
        salCollRankPerm.setFormKey("mobsm_salcollrank");
        salCollRankPerm.setOpPermItemList(Collections.singletonList(salCollRankPermItem));
        saleAnalysisPermItemInfo.add(salCollRankPerm);
        BizEntityPermItemInfo custOrderDelRatePerm = new BizEntityPermItemInfo();
        OpPermItemInfo custOrderDelRatePermItem = new OpPermItemInfo();
        custOrderDelRatePermItem.setItemKey("custorderdelrate");
        custOrderDelRatePermItem.setPermItemId("47150e89000000ac");
        custOrderDelRatePerm.setFormKey("mobsm_custdeltimelyrate");
        custOrderDelRatePerm.setOpPermItemList(Collections.singletonList(custOrderDelRatePermItem));
        saleAnalysisPermItemInfo.add(custOrderDelRatePerm);
        BizEntityPermItemInfo custSalNewsPerm = new BizEntityPermItemInfo();
        OpPermItemInfo custSalNewsPermItem = new OpPermItemInfo();
        custSalNewsPermItem.setItemKey("custsalnews");
        custSalNewsPermItem.setPermItemId("47150e89000000ac");
        custSalNewsPerm.setFormKey("mobsm_custsalnews");
        custSalNewsPerm.setOpPermItemList(Collections.singletonList(custSalNewsPermItem));
        saleAnalysisPermItemInfo.add(custSalNewsPerm);
        return saleAnalysisPermItemInfo;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext requestContext = RequestContext.get();
        Long orgId = requestContext.getOrgId();
        this.checkPermission(orgId);
    }

    private void checkPermission(Long org) {
        IFormView view = this.getView();
        Long orgId = this.setOrg(org);
        if (orgId == null || orgId.equals(0L)) {
            view.setVisible(Boolean.FALSE, new String[]{"icon_saleorder", "icon_delivernotice", "icon_returnapply", "icon_outorder", "customervalue", "salorgrevanal", "prodsalpropanal", "newcustomeranal", "salperfrank", "salcollrank", "custorderdelrate", "custsalnews", "submitdelivernotice", "submitsaleorder"});
            return;
        }
        for (BizEntityPermItemInfo entityPerm : this.entityPermCache) {
            int showItemSize;
            String formKey = entityPerm.getFormKey();
            List<OpPermItemInfo> opPermItems = entityPerm.getOpPermItemList();
            ArrayList<String> toHideItems = new ArrayList<String>(10);
            ArrayList<String> toShowItems = new ArrayList<String>(10);
            for (OpPermItemInfo opPermItem : opPermItems) {
                String itemKey = opPermItem.getItemKey();
                String permItemId = opPermItem.getPermItemId();
                boolean permResult = PermissionHelper.checkPermission(orgId, "sm", formKey, permItemId);
                if (!permResult) {
                    toHideItems.add(itemKey);
                    continue;
                }
                toShowItems.add(itemKey);
            }
            int hideItemSize = toHideItems.size();
            if (hideItemSize > 0) {
                view.setVisible(Boolean.FALSE, toHideItems.toArray(new String[hideItemSize]));
            }
            if ((showItemSize = toShowItems.size()) <= 0) continue;
            view.setVisible(Boolean.TRUE, toShowItems.toArray(new String[showItemSize]));
        }
    }

    private Long setOrg(Long orgId) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List<Long> hasPermOrgs = PermissionHelper.getUserAllHasPermOrgs();
        if (hasPermOrgs.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u6388\u6743\u3002", (String)"AppHomePlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            orgId = null;
        } else if (!hasPermOrgs.contains(orgId)) {
            orgId = hasPermOrgs.get(0);
        }
        model.setValue("org", (Object)orgId);
        return orgId;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if ("org".equals(fieldKey)) {
            this.beforeOrgSelect(e);
        }
    }

    private void beforeOrgSelect(BeforeF7SelectEvent e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        Long orgId = org == null ? 0L : org.getLong("id");
        this.checkPermission(orgId);
        FormShowParameter showParameter = e.getFormShowParameter();
        List<Long> hasPermOrgs = PermissionHelper.getUserAllHasPermOrgs();
        if (hasPermOrgs.isEmpty()) {
            model.setValue("org", null);
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u6388\u6743\u3002", (String)"AppHomePlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            hasPermOrgs = new ArrayList<Long>(10);
        }
        showParameter.setCustomParam("range", hasPermOrgs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("org".equals(proName)) {
            Long orgId = newValue == null ? 0L : ((DynamicObject)newValue).getLong("id");
            this.checkPermission(orgId);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control control = (Control)e.getSource();
        String opKey = control.getKey();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String orgNumber = org == null ? "" : org.getString("number");
        QFilter orgFilter = StringUtils.isEmpty((CharSequence)orgNumber) ? new QFilter(IDENT_EQ_KEY, "!=", (Object)IDENT_EQ_VAL) : new QFilter("org.number", "=", (Object)orgNumber);
        switch (opKey) {
            case "submitsaleorder": {
                this.openListPage(view, "mobsm_salorder", orgFilter);
                break;
            }
            case "submitdelivernotice": {
                this.openListPage(view, "mobsm_delivernotice", orgFilter);
                break;
            }
            case "icon_saleorder": {
                PageUtils.openListPage(view, "mobsm_salorder", orgFilter, null);
                break;
            }
            case "icon_delivernotice": {
                PageUtils.openListPage(view, "mobsm_delivernotice", orgFilter, null);
                break;
            }
            case "icon_returnapply": {
                PageUtils.openListPage(view, "mobsm_returnapply", orgFilter, null);
                break;
            }
            case "icon_outorder": {
                PageUtils.openListPage(view, "mobim_saloutbilllist", orgFilter, null);
                break;
            }
            case "customervalue": {
                PageUtils.openFormPage(view, "mobsm_customeranalysis", this.getCustomParam(), null);
                break;
            }
            case "salorgrevanal": {
                PageUtils.openFormPage(view, "mobsm_salorgrevanal", this.getCustomParam(), null);
                break;
            }
            case "prodsalpropanal": {
                PageUtils.openFormPage(view, "mobsm_prodsalpropanal", this.getCustomParam(), null);
                break;
            }
            case "newcustomeranal": {
                PageUtils.openFormPage(view, "mobsm_newcustomeranal", this.getCustomParam(), null);
                break;
            }
            case "salperfrank": {
                PageUtils.openFormPage(view, "mobsm_salperfrank", this.getCustomParam(), null);
                break;
            }
            case "salcollrank": {
                PageUtils.openFormPage(view, "mobsm_salcollrank", this.getCustomParam(), null);
                break;
            }
            case "custorderdelrate": {
                PageUtils.openFormPage(view, "mobsm_custdeltimelyrate", this.getCustomParam(), null);
                break;
            }
            case "custsalnews": {
                PageUtils.openFormPage(view, "mobsm_custsalnews", this.getCustomParam(), null);
                break;
            }
        }
    }

    public void openListPage(IFormView view, String formKey, QFilter qFilter) {
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setFormId("bos_moblist");
        showParameter.setBillFormId(formKey);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("billstatus", (Object)SUBMIT_STATUS);
        view.showForm((FormShowParameter)showParameter);
    }

    private Map<String, Object> getCustomParam() {
        HashMap<String, Object> parameter = new HashMap<String, Object>(3);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = org == null ? null : (Long)org.getPkValue();
        parameter.put("org", orgId);
        return parameter;
    }
}

